% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_predicted_expr}
\alias{plot_predicted_expr}
\title{Scatter plot of predicted vs measured gene expression levels}
\usage{
plot_predicted_expr(
  pred_obj,
  title = "Predicted expression",
  is_margins = FALSE
)
}
\arguments{
\item{pred_obj}{The output of the \code{predict_expr} function.}

\item{title}{The title of the plot.}

\item{is_margins}{Use specified margins or not.}
}
\value{
A ggplot2 object.
}
\description{
\code{plot_predicted_expr} creates a scatter plot of predicted
  gene expression values on the x-axis versus the measured gene expression
  values on the y-axis.
}
\examples{
# Fit methylation profiles using 5 RBFs
basis <- create_rbf_object(M = 5)
prof <- infer_profiles_vb(X = encode_met$met, model = "binomial",
    basis = basis, is_parallel = FALSE, vb_max_iter = 5)
# Predict expression
pred_obj <- predict_expr(prof_obj = prof, expr = encode_expr,
  anno = encode_met$anno, model_name = "lm", is_summary = FALSE)
# Create plot
g <- plot_predicted_expr(pred_obj = pred_obj)

}
\seealso{
\code{\link{plot_infer_profiles}},
  \code{\link{plot_cluster_profiles}}, \code{\link{boxplot_cluster_expr}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
