% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_infer_profiles}
\alias{plot_infer_profiles}
\title{Plot inferred methylation profiles across a region}
\usage{
plot_infer_profiles(
  region = 1,
  obj_prof,
  obj_mean = NULL,
  obs = NULL,
  title = "Inferred profiles",
  x_axis = "genomic region",
  y_axis = "met level",
  x_labels = c("Upstream", "", "Centre", "", "Downstream"),
  ...
)
}
\arguments{
\item{region}{Genomic region number}

\item{obj_prof}{Inferred profile, i.e. output from
\code{\link{infer_profiles_vb}} or \code{\link{infer_profiles_mle}}}

\item{obj_mean}{Inferred mean function, i.e. output from
\code{\link{infer_profiles_vb}} or \code{\link{infer_profiles_mle}}}

\item{obs}{Methylation data observations, if a list, will extract the
specific \code{region}, if a matrix will plot directly its observations.}

\item{title}{Plot title}

\item{x_axis}{x axis label}

\item{y_axis}{x axis label}

\item{x_labels}{x axis ticks labels}

\item{...}{Additional parameters}
}
\value{
A ggplot2 object.
}
\description{
Function for plotting the inferred methylation profiles across a
  given region, and optionally the mean methylation rate together with the
  observed methylation data, using \code{\link{ggplot2}}.
}
\examples{
# Fit methylation profiles using 5 RBFs
basis <- create_rbf_object(M = 5)
prof <- infer_profiles_vb(X = encode_met$met, model = "binomial",
    basis = basis, is_parallel = FALSE, vb_max_iter = 5)
# Create the plot
g <- plot_infer_profiles(region = 16, obj_prof = prof, obs = encode_met$met)

}
\seealso{
\code{\link{plot_predicted_expr}},
\code{\link{plot_cluster_profiles}},
  \code{\link{boxplot_cluster_expr}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
