% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_data.R
\name{partition_bulk_dataset}
\alias{partition_bulk_dataset}
\title{Partition bulk methylation dataset to training and test set}
\usage{
partition_bulk_dataset(dt_obj, cpg_train_prcg = 0.5)
}
\arguments{
\item{dt_obj}{BPRMeth data `region_object` object}

\item{cpg_train_prcg}{Fraction of CpGs in each genomic region to keep for
training set.}
}
\value{
The BPRMeth data `region_object` object with the following changes.
  The `met` element will now contain only the `training` data. An additional
  element called `met_test` will store the data that will be used during
  testing to evaluate the imputation performance. These data will not be seen
  from BPRMeth during inference.
}
\description{
Partition bulk methylation dataset to training and test set
}
\examples{
# Partition the synthetic data from BPRMeth package
dt <- partition_bulk_dataset(encode_met)

}
\seealso{
\code{\link{create_region_object}}, \code{\link{read_met}},
  \code{\link{impute_bulk_met}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
