% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/model_log_likelihood.R
\name{bpr_log_likelihood}
\alias{bpr_log_likelihood}
\alias{bpr_gradient}
\alias{betareg_log_likelihood}
\alias{betareg_gradient}
\alias{sum_weighted_bpr_lik}
\alias{sum_weighted_bpr_grad}
\alias{sum_weighted_betareg_lik}
\alias{sum_weighted_betareg_grad}
\alias{model_log_likelihood}
\alias{obs_model_likelihood}
\alias{obs_log_likelihood}
\alias{model_likelihood}
\alias{lr_log_likelihood}
\title{Compute observation model log-likelihood}
\usage{
bpr_log_likelihood(w, X, H, lambda, is_nll)

bpr_gradient(w, X, H, lambda, is_nll)

betareg_log_likelihood(w, X, H, lambda, is_nll)

betareg_gradient(w, X, H, lambda, is_nll)

sum_weighted_bpr_lik(w, X_list, H_list, r_nk, lambda, is_nll)

sum_weighted_bpr_grad(w, X_list, H_list, r_nk, lambda, is_nll)

sum_weighted_betareg_lik(w, X_list, H_list, r_nk, lambda, is_nll)

sum_weighted_betareg_grad(w, X_list, H_list, r_nk, lambda, is_nll)

lr_log_likelihood(w, X, H, lambda = 0.5, is_nll = FALSE)
}
\arguments{
\item{w}{A vector of parameters (i.e. coefficients of the basis functions)}

\item{X}{An \code{L X C} matrix, where L are the total number of
observations. The first column contains the input observations x (i.e. CpG
locations). If "binomial" model then C=3, and 2nd and 3rd columns contain
total number of trials and number of successes respectively. If "bernoulli"
or "gaussian" model, then C=2 containing the output y (e.g. methylation
level). if "beta" model, then C=3, where 2nd column contains output y and
3rd column the dispersion parameter. Each row corresponds to each row of
the design matrix \code{H}.}

\item{H}{The \code{L x M} matrix design matrix, where L is the number of
observations and M the number of basis functions.}

\item{lambda}{The complexity penalty coefficient for penalized regression.}

\item{is_nll}{Logical, indicating if the Negative Log Likelihood should be
returned.}

\item{X_list}{A list of elements of length N, where each element is an
\code{L x K} matrix of observations X.}

\item{H_list}{A list of elements of length N, where each element contains the
\code{L x M} design matrices \code{H}.}

\item{r_nk}{A vector of length N containing the posterior probabilities (i.e.
responsibilities) for each element of \code{X_list}.}
}
\value{
Returns the log likelihood or gradient of the observation model.
}
\description{
These functions evaluate the model log-likelihood and gradient
  for different observation models. Available models are "bpr" (i.e.
  "bernoulli" or "binomial"), "beta" and "lr" (i.e. "gaussian"). There are
  also functions to compute the sum and weighted sum of the observation model
  likelihoods, e.g. required for the EM algorithm. These functions are
  written in C++ for efficiency.
}
\seealso{
\code{\link{eval_functions}}, \code{\link{infer_profiles_mle}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
