% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_expr.R
\name{inner_train_model_expr}
\alias{inner_train_model_expr}
\title{(INNER) Train expression model from methylation profiles}
\usage{
inner_train_model_expr(
  formula = NULL,
  model_name = "lm",
  train,
  is_summary = TRUE
)
}
\arguments{
\item{formula}{An object of class \code{\link[stats]{formula}}, e.g. see
\code{\link[stats]{lm}} function. If NULL, the simple linear model is used.}

\item{model_name}{A string denoting the regression model. Currently,
available models are: \code{"svm"}, \code{"randomForest"}, \code{"rlm"},
\code{"mars"}, \code{"gp"}, and \code{"lm"}.}

\item{train}{The training data.}

\item{is_summary}{Logical, print the summary statistics.}
}
\value{
A list containing the following elements: \itemize{ \item
  \code{formula}: The formula that was used. \item \code{gex_model}: The
  fitted model. \item \code{train_pred} The predicted values for the training
  data. \item \code{train_errors}: The training error metrics. }
}
\description{
This function trains a regression model for
  predicting gene expression levels by taking as input the higher order
  methylation features extracted from specific genomic regions.
}
\examples{
# Create synthetic data
train_data <- data.frame(x = rnorm(20), y=rnorm(20, 1, 4))
res <- inner_train_model_expr(formula = y~., train = train_data)

# Using a different model
res <- inner_train_model_expr(model_name = "randomForest",
                              train = train_data)

}
\seealso{
\code{\link{predict_expr}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
