% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_expr.R
\name{inner_predict_model_expr}
\alias{inner_predict_model_expr}
\title{(INNER) Predict expression}
\usage{
inner_predict_model_expr(model, test, is_summary = TRUE)
}
\arguments{
\item{model}{The fitted regression model, i.e. the output of
\code{\link{inner_train_model_expr}}.}

\item{test}{The testing data.}

\item{is_summary}{Logical, print the summary statistics.}
}
\value{
A list containing the following elements: \itemize{ \item
  \code{test_pred}: The predicted values for the test data. \item
  \code{test_errors}: The test error metrics. }
}
\description{
This functions makes predictions of gene expression levels using
  a model trained on methylation features extracted from genomic regions.
}
\examples{
# Create synthetic data
train_data <- data.frame(x = rnorm(20), y=rnorm(20, 1, 4))
test_data <- data.frame(x = rnorm(40), y=rnorm(20, 1, 3))

# Train the model
train_model <- inner_train_model_expr(formula = y~., model_name="svm",
                                      train = train_data)

# Make predictions
res <- inner_predict_model_expr(model = train_model$model, test = test_data)

}
\seealso{
\code{\link{predict_expr}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
