% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer_profiles_vb.R
\name{infer_profiles_vb}
\alias{infer_profiles_vb}
\alias{infer_profile_vb}
\alias{inference_vb}
\title{Infer methylation profiles using VB}
\usage{
infer_profiles_vb(
  X,
  model = NULL,
  basis = NULL,
  H = NULL,
  w = NULL,
  gaussian_l = 50,
  alpha_0 = 0.5,
  beta_0 = 0.1,
  vb_max_iter = 100,
  epsilon_conv = 1e-05,
  is_parallel = FALSE,
  no_cores = NULL,
  is_verbose = FALSE,
  ...
)
}
\arguments{
\item{X}{The input data, either a \code{\link[base]{matrix}} or a
\code{\link[base]{list}} of elements of length N, where each element is an
\code{L X C} matrix, where L are the total number of observations. The
first column contains the input observations x (i.e. CpG locations). If
"binomial" model then C=3, and 2nd and 3rd columns contain total number of
trials and number of successes respectively. If "bernoulli" or "gaussian"
model, then C=2 containing the output y (e.g. methylation level).}

\item{model}{Observation model name as character string. It can be either
'bernoulli', 'binomial', 'beta' or 'gaussian'.}

\item{basis}{A 'basis' object. E.g. see \code{\link{create_basis}}. If NULL,
will an RBF object will be created.}

\item{H}{Optional, design matrix of the input data X. If NULL, H will be
computed inside the function.}

\item{w}{A vector of initial parameters (i.e. coefficients of the basis
functions). If NULL, it will be initialized inside the function.}

\item{gaussian_l}{Noise precision parameter, only used when having "gaussian"
observation model.}

\item{alpha_0}{Hyperparameter: shape parameter for Gamma distribution. A
Gamma distribution is used as prior for the precision parameter tau.}

\item{beta_0}{Hyperparameter: rate parameter for Gamma distribution. A Gamma
distribution is used as prior for the precision parameter tau.}

\item{vb_max_iter}{Integer denoting the maximum number of VB iterations.}

\item{epsilon_conv}{Numeric denoting the convergence threshold for VB.}

\item{is_parallel}{Logical, indicating if code should be run in parallel.}

\item{no_cores}{Number of cores to be used, default is max_no_cores - 1.}

\item{is_verbose}{Logical, print results during VB iterations.}

\item{...}{Additional parameters.}
}
\value{
An object of class \code{infer_profiles_vb_}"obs_model" with the
  following elements: \itemize{ \item{ \code{W}: An Nx(M+1) matrix with the
  optimized parameter values. Each row of the matrix corresponds to each
  element of the list X; if X is a matrix, then N = 1. The columns are of the
  same length as the parameter vector w (i.e. number of basis functions). }
  \item{ \code{W_Sigma}: A list with covariance matrices for each element row
  in W.} \item{ \code{basis}: The basis object. } \item{\code{nll_feat}: NLL
  fit feature.} \item{\code{rmse_feat}: RMSE fit feature.}
  \item{\code{coverage_feat}: CpG coverage feature.} \item{\code{lb_feat}:
  Lower Bound feature.}}
}
\description{
General purpose functions for inferring latent profiles for
  different observation models using Variational Bayes (VB). Current
  observation models are: 'bernoulli', 'binomial' or 'gaussian'.
}
\section{Details}{
 The modelling and mathematical details for inferring
  profiles using mean-field variational inference are explained here:
  \url{http://rpubs.com/cakapourani/} . More specifically: \itemize{\item{For
  Binomial/Bernoulli observation model check:
  \url{http://rpubs.com/cakapourani/variational-bayes-bpr}} \item{For
  Gaussian observation model check:
  \url{http://rpubs.com/cakapourani/variational-bayes-lr}}}
}

\examples{
# Example of inferring parameters for synthetic data using 3 RBFs
basis <- create_rbf_object(M=3)
out <- infer_profiles_vb(X = binomial_data, model = "binomial",
   basis = basis, is_parallel = FALSE, vb_max_iter = 10)

#-------------------------------------

basis <- create_rbf_object(M=3)
out <- infer_profiles_vb(X = gaussian_data, model = "gaussian",
   basis = basis, is_parallel = FALSE, vb_max_iter = 10)

}
\seealso{
\code{\link{create_basis}}, \code{\link{infer_profiles_mle}},
  \code{\link{predict_expr}}, \code{\link{create_region_object}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
