% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer_profiles_mle.R
\name{infer_profiles_mle}
\alias{infer_profiles_mle}
\alias{infer_profile_mle}
\alias{inference_mle}
\title{Infer methylation profiles using MLE}
\usage{
infer_profiles_mle(
  X,
  model = NULL,
  basis = NULL,
  H = NULL,
  lambda = 0.5,
  w = NULL,
  beta_dispersion = 5,
  opt_method = "CG",
  opt_itnmax = 100,
  is_parallel = FALSE,
  no_cores = NULL,
  ...
)
}
\arguments{
\item{X}{The input data, either a \code{\link[base]{matrix}} or a
\code{\link[base]{list}} of elements of length N, where each element is an
\code{L X C} matrix, where L are the total number of observations. The
first column contains the input observations x (i.e. CpG locations). If
"binomial" model then C=3, and 2nd and 3rd columns contain total number of
trials and number of successes respectively. If "bernoulli" or "gaussian"
model, then C=2 containing the output y (e.g. methylation level). If "beta"
model, then C=3, where 2nd column contains output y and 3rd column the
dispersion parameter.}

\item{model}{Observation model name as character string. It can be either
'bernoulli', 'binomial', 'beta' or 'gaussian'.}

\item{basis}{A 'basis' object. E.g. see \code{\link{create_basis}}. If NULL,
will an RBF object will be created.}

\item{H}{Optional, design matrix of the input data X. If NULL, H will be
computed inside the function.}

\item{lambda}{The complexity penalty coefficient for ridge regression.}

\item{w}{A vector of initial parameters (i.e. coefficients of the basis
functions).}

\item{beta_dispersion}{Dispersion parameter, only used for Beta distribution
and will be the same for all observations.}

\item{opt_method}{The optimization method to be used. See
\code{\link[stats]{optim}} for possible methods. Default is "CG".}

\item{opt_itnmax}{Optional argument giving the maximum number of iterations
for the corresponding method. See \code{\link[stats]{optim}} for details.}

\item{is_parallel}{Logical, indicating if code should be run in parallel.}

\item{no_cores}{Number of cores to be used, default is max_no_cores - 1.}

\item{...}{Additional parameters.}
}
\value{
An object of class \code{infer_profiles_mle_}"obs_model" with the
  following elements: \itemize{ \item{ \code{W}: An Nx(M+1) matrix with the
  optimized parameter values. Each row of the matrix corresponds to each
  element of the list X; if X is a matrix, then N = 1. The columns are of the
  same length as the parameter vector w (i.e. number of basis functions). }
  \item{ \code{basis}: The basis object. } \item{\code{nll_feat}: NLL fit
  feature.} \item{\code{rmse_feat}: RMSE fit feature.}
  \item{\code{coverage_feat}: CpG coverage feature.}}
}
\description{
General purpose functions for inferring latent profiles for
  different observation models using maximum likelihood estimation (MLE).
  Current observation models are: 'bernoulli', 'binomial', 'beta' or
  'gaussian'. For most models we cannot obtain an analytically tractable
  solution, hence an optimization procedure is used. The
  \code{\link[stats]{optim}} package is used for performing optimization.
}
\section{Details}{
 The beta regression model is based on alternative
  parameterization of the beta density in terms of the mean and dispersion
  parameter: \url{https://cran.r-project.org/web/packages/betareg/} . For
  modelling details for Binomial/Bernoulli observation model check the paper
  for BPRMeth:
  \url{https://academic.oup.com/bioinformatics/article/32/17/i405/2450762} .
}

\examples{
# Example of optimizing parameters for synthetic data using 3 RBFs
basis <- create_rbf_object(M=3)
out <- infer_profiles_mle(X = binomial_data, model = "binomial",
   basis = basis, is_parallel = FALSE, opt_itnmax = 10)

#-------------------------------------

basis <- create_rbf_object(M=3)
out <- infer_profiles_mle(X = beta_data, model = "beta",
   basis = basis, is_parallel = FALSE, opt_itnmax = 10)

#-------------------------------------

basis <- create_rbf_object(M=3)
out <- infer_profiles_mle(X = gaussian_data[[1]], model = "gaussian",
   basis = basis, is_parallel = FALSE, opt_itnmax = 10)

}
\seealso{
\code{\link{create_basis}}, \code{\link{infer_profiles_vb}},
  \code{\link{infer_profiles_gibbs}}, \code{\link{create_region_object}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
