% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_data.R
\name{impute_bulk_met}
\alias{impute_bulk_met}
\title{Impute/predict bulk methylation states}
\usage{
impute_bulk_met(obj, anno, test_data = NULL, return_test = FALSE)
}
\arguments{
\item{obj}{Output of BPRMeth inference object.}

\item{anno}{A \code{GRanges} object with annotation data, whose format
should be similar to  \code{\link{read_anno}}.}

\item{test_data}{Test data to evaluate performance.}

\item{return_test}{Whether or not to return a list with the predictions.}
}
\value{
A list containing two vectors, the true methylation state and the
  predicted/imputed methylation states.
}
\description{
Make predictions of missing methylation states, i.e. perfrom
  imputation using BPRmeth This requires keepin a subset of data as a held
  out test set during BPRMeth inference or providing a different file that
  contains chromosome and CpG locations.
}
\examples{
# Extract synthetic data
dt <- encode_met

# Partition to train and test set
dt <- partition_bulk_dataset(dt)

# Create basis object
basis_obj <- create_rbf_object(M = 3)

# Run BPRMeth
fit <- infer_profiles_mle(X = dt$met, model = "binomial",
   basis = basis_obj, is_parallel = FALSE, opt_itnmax = 10)

# Perform imputation
imputation_obj <- impute_bulk_met(obj = fit, anno = dt$anno,
                                  test_data = dt$met_test)

}
\seealso{
\code{\link{partition_bulk_dataset}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
