% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis_functions.R
\name{eval_functions}
\alias{eval_functions}
\alias{eval_probit_function}
\alias{eval_function}
\alias{eval_function.rbf}
\alias{eval_function.polynomial}
\alias{eval_function.fourier}
\title{Evaluate basis functions}
\usage{
eval_probit_function(obj, ...)

eval_function(obj, ...)

\method{eval_function}{rbf}(obj, obs, w, ...)

\method{eval_function}{polynomial}(obj, obs, w, ...)

\method{eval_function}{fourier}(obj, obs, w, ...)
}
\arguments{
\item{obj}{The basis function object.}

\item{...}{Optional additional parameters}

\item{obs}{Observation data.}

\item{w}{Vector of length M, containing the coefficients of an
M\eqn{^{th}}-order basis function.}
}
\value{
The evaluated function values.

  NOTE that the \code{eval_probit_function} computes the probit transformed
  basis function values.
}
\description{
Method for evaluating an M basis function model with observation
  data \code{obs} and coefficients \code{w}.
}
\examples{
# Evaluate the probit transformed basis function values
obj <- create_rbf_object(M=2)
obs <- c(1,2,3)
w <- c(0.1, 0.3, -0.6)
out <- eval_probit_function(obj, obs, w)

# -------------------------

# Evaluate the RBF basis function values
obj <- create_rbf_object(M=2, mus = c(2,2.5))
obs <- c(1,2,3)
w <- c(0.1, 0.3, -0.6)
out <- eval_function(obj, obs, w)

# -------------------------

# Evaluate the Polynomial basis function values
obj <- create_polynomial_object(M=2)
obs <- c(1,2,3)
w <- c(0.1, 0.3, -0.6)
out <- eval_function(obj, obs, w)

# -------------------------

# Evaluate the Fourier basis function values
obj <- create_fourier_object(M=2)
obs <- c(1,2,3)
w <- c(0.1, 0.3, -0.6)
out <- eval_function(obj, obs, w)

}
\seealso{
\code{\link{create_basis}}, \code{\link{design_matrix}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
