% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_matrix.R
\name{design_matrix}
\alias{design_matrix}
\alias{designmatrix}
\alias{des_matrix}
\alias{des_mat}
\alias{design_matrix.default}
\alias{design_matrix.polynomial}
\alias{design_matrix.rbf}
\alias{design_matrix.fourier}
\title{Generic function for creating design matrices}
\usage{
design_matrix(obj, ...)

\method{design_matrix}{default}(obj, ...)

\method{design_matrix}{polynomial}(obj, obs, ...)

\method{design_matrix}{rbf}(obj, obs, ...)

\method{design_matrix}{fourier}(obj, obs, ...)
}
\arguments{
\item{obj}{A basis function object.}

\item{...}{Additional parameters.}

\item{obs}{A vector of observations.}
}
\value{
A design matrix object
}
\description{
These functions call the appropriate methods depending on the
  class of the object \code{obj} to create RBF, polynomial or Fourier design
  matrices.
}
\examples{
obj <- create_polynomial_object(M=2)
obs <- c(0,.2,.5)
poly <- design_matrix(obj, obs)

#----------------

obj <- create_rbf_object(M=2)
obs <- c(0,.2,.5)
rbf <- design_matrix(obj, obs)

#----------------

obj <- create_fourier_object(M=2)
obs <- c(0,.2,.5)
fourier <- design_matrix(obj, obs)

}
\seealso{
\code{\link{create_basis}}, \code{\link{eval_functions}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
