% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_data.R
\name{create_region_object}
\alias{create_region_object}
\alias{genomic_region}
\alias{region_object}
\alias{met_region}
\alias{create_region}
\alias{create_region_obj}
\title{Create genomic region data}
\usage{
create_region_object(
  met_dt,
  anno_dt,
  cov = 5,
  sd_thresh = 0.1,
  ignore_strand = TRUE,
  filter_empty_region = TRUE,
  fmin = -1,
  fmax = 1
)
}
\arguments{
\item{met_dt}{A \code{GRanges} object with methylation data, whose format
should be similar to \code{\link{read_met}} function.}

\item{anno_dt}{A \code{GRanges} object with annotation data, whose format
should be similar to  \code{\link{read_anno}}.}

\item{cov}{Integer defining the minimum coverage of CpGs that each region
must contain.}

\item{sd_thresh}{Optional numeric defining the minimum standard deviation of
the methylation change in a region. This is used to filter regions with no
methylation variability.}

\item{ignore_strand}{Logical, whether or not to ignore strand information.}

\item{filter_empty_region}{Logical, whether to discard genomic regions that
have no CpG coverage or do not pass filtering options.}

\item{fmin}{Minimum range value for location scaling. Under this version, it
should be left to its default value -1.}

\item{fmax}{Maximum range value for location scaling. Under this version, it
should be left to its default value 1.}
}
\value{
A \code{list} object containing the two elements: \itemize{ \item{
  \code{met}: A list containing methylation region data, where each entry in
  the list is an \eqn{L_{i} X D} dimensional matrix, where \eqn{L_{i}}
  denotes the number of CpGs found in region \code{i}. The columns contain
  the following information: \enumerate{ \item{ 1st column: Contains the
  locations of CpGs relative to centre. Note that the actual locations are
  scaled to the (fmin, fmax) region. } \item{ 2nd column: If "bulk" data
  (i.e. binomial) it contains the total number of reads at each CpG location,
  otherwise the methylation level.} \item{ 3rd column: If "bulk" data, the
  methylated reads at each CpG location, otherwise this D = 2 and this column
  is absent.} }. Rownames of each matrix contain the actual CpG genomic
  coordinates as <chr>:<location>. } \item{ \code{anno}: The annotation
  object.} } Note: The lengths of \code{met} and \code{anno} should match.
}
\description{
\code{create_region_object} creates genomic regions (e.g. forms
  methylation regions data) using as input methylation and annotation data
  with genomic regions of interest.
}
\examples{
\dontrun{
# Download the files and change the working directory to that location
met_dt <- read_met("name_of_met_file")
anno_dt <- read_anno("name_of_anno_file")

obj <- create_region_object(met_dt, anno_dt)

# Extract methylation regions
met <- obj$met
}

}
\seealso{
\code{\link{read_met}}, \code{\link{read_anno}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
