% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis_functions.R
\name{create_basis}
\alias{create_basis}
\alias{basis}
\alias{create_basis_function}
\alias{create_rbf_object}
\alias{create_polynomial_object}
\alias{create_fourier_object}
\title{Create basis objects}
\usage{
create_rbf_object(
  M = 2,
  gamma = NULL,
  mus = NULL,
  eq_spaced_mus = TRUE,
  whole_region = TRUE
)

create_polynomial_object(M = 1)

create_fourier_object(M = 2, period = 2)
}
\arguments{
\item{M}{The number of the basis functions. In case of Fourier basis, this
number should be even, since we need to have pairs of sines and cosines and
the constant term is added by default.}

\item{gamma}{Inverse width of radial basis function.}

\item{mus}{Optional centers of the RBF.}

\item{eq_spaced_mus}{Logical, if TRUE, equally spaced centers are created,
otherwise centers are created using \code{\link[stats]{kmeans}} algorithm.}

\item{whole_region}{Logical, indicating if the centers will be evaluated
equally spaced on the whole region, or between the min and max of the
observation values.}

\item{period}{The period, that is the basis functions are periodic on a
specific interval. Best choice is the range of the points used for
regression.}
}
\value{
A basis object of class 'rbf', 'polynomial' or 'fourier'.
}
\description{
These functions create different basis objects, which can be
  used as input to complex functions in order to perform computations
  depending on the class of the basis function.
}
\examples{
(obj <- create_rbf_object(M = 2))

#---------------------------------

(obj <- create_polynomial_object(M = 2))

(obj <- create_fourier_object(M = 2, period = 1))

}
\seealso{
\code{\link{eval_functions}}, \code{\link{design_matrix}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
