% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_data.R
\name{create_anno_region}
\alias{create_anno_region}
\title{Create annotation regions}
\usage{
create_anno_region(
  anno,
  chrom_size = NULL,
  is_centre = FALSE,
  is_window = TRUE,
  upstream = -5000,
  downstream = 5000
)
}
\arguments{
\item{anno}{A \code{GRanges} object containing the annotation data, this
normally would be the output from \code{\link{read_anno}} function.}

\item{chrom_size}{Object containing genome chromosome sizes, normally would
be the output of \code{\link{read_chrom_size}} function.}

\item{is_centre}{Logical, whether 'start' and 'end' locations are
pre-centred. If TRUE, the mean of the locations will be chosen as centre.
If FALSE, the 'start' will be chosen as the center; e.g. for genes the
'start' denotes the TSS and we use this as centre to obtain K-bp upstream
and downstream of TSS.}

\item{is_window}{Whether to consider a predefined window region around
centre. If TRUE, then 'upstream' and 'downstream' parameters are used,
otherwise we consider the whole region from start to end location.}

\item{upstream}{Integer defining the length of bp upstream of 'centre' for
creating the genomic region. If is_window = FALSE, this parameter is
ignored.}

\item{downstream}{Integer defining the length of bp downstream of 'centre'
for creating the genomic region. If is_window = FALSE, this parameter is
ignored.}
}
\value{
A \code{GRanges} object containing the genomic regions.

  The GRanges object contains two or three additional metadata column:
  \itemize{\item{\code{id}: Genomic region id.} \item{\code{centre}: Central
  location of each genomic region.} \item{\code{name}: (Optional) Genomic
  region name.} } This column can be accessed as follows:
  \code{granges_object$tss}
}
\description{
\code{create_anno_region} creates annotation regions from
  annotation data, using the central point of the annotation features as
  ground truth labels we create genomic regions \code{N} bp upstream and
  \code{M} bp downstream of central location.
}
\examples{
# Obtain the path to files
file <- system.file("extdata", "dummy_anno.bed", package = "BPRMeth")
anno_dt <- read_anno(file, is_anno_region = FALSE)
# Create genomic region
gen_region <- create_anno_region(anno_dt)
# Extract ID
id <- gen_region$id

}
\seealso{
\code{\link{create_region_object}}, \code{\link{read_anno}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
