% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_profiles_vb.R
\name{cluster_profiles_vb}
\alias{cluster_profiles_vb}
\alias{cluster_profile_vb}
\alias{cluster_vb}
\title{Cluster methylation profiles using VB}
\usage{
cluster_profiles_vb(
  X,
  K = 3,
  model = NULL,
  basis = NULL,
  H = NULL,
  delta_0 = NULL,
  w = NULL,
  gaussian_l = 50,
  alpha_0 = 0.5,
  beta_0 = 0.1,
  vb_max_iter = 100,
  epsilon_conv = 1e-04,
  is_verbose = FALSE,
  ...
)
}
\arguments{
\item{X}{The input data, which has to be a \code{\link[base]{list}} of
elements of length N, where each element is an \code{L X C} matrix, where L
are the total number of observations. The first column contains the input
observations x (i.e. CpG locations). If "binomial" model then C=3, and 2nd
and 3rd columns contain total number of trials and number of successes
respectively. If "bernoulli" or "gaussian" model, then C=2 containing the
output y (e.g. methylation level).}

\item{K}{Integer denoting the total number of clusters K.}

\item{model}{Observation model name as character string. It can be either
'bernoulli', 'binomial', 'beta' or 'gaussian'.}

\item{basis}{A 'basis' object. E.g. see \code{\link{create_basis}}. If NULL,
will an RBF object will be created.}

\item{H}{Optional, design matrix of the input data X. If NULL, H will be
computed inside the function.}

\item{delta_0}{Parameter vector of the Dirichlet prior on the mixing
proportions pi.}

\item{w}{Optional, an (M+1)xK matrix of the initial parameters, where each
column consists of the basis function coefficients for each corresponding
cluster k. If NULL, will be assigned with default values.}

\item{gaussian_l}{Noise precision parameter, only used when having "gaussian"
observation model.}

\item{alpha_0}{Hyperparameter: shape parameter for Gamma distribution. A
Gamma distribution is used as prior for the precision parameter tau.}

\item{beta_0}{Hyperparameter: rate parameter for Gamma distribution. A Gamma
distribution is used as prior for the precision parameter tau.}

\item{vb_max_iter}{Integer denoting the maximum number of VB iterations.}

\item{epsilon_conv}{Numeric denoting the convergence threshold for VB.}

\item{is_verbose}{Logical, print results during VB iterations.}

\item{...}{Additional parameters.}
}
\value{
An object of class \code{cluster_profiles_vb_}"obs_model" with the
  following elements: \itemize{ \item{ \code{W}: An (M+1) X K matrix with the
  optimized parameter values for each cluster, M are the number of basis
  functions. Each column of the matrix corresponds a different cluster k.}
  \item{ \code{W_Sigma}: A list with the covariance matrices of the posterior
  parmateter W for each cluster k.} \item{ \code{r_nk}: An (N X K)
  responsibility matrix of each observations being explained by a specific
  cluster. } \item{ \code{delta}: Optimized Dirichlet paramter for the mixing
  proportions. } \item{ \code{alpha}: Optimized shape parameter of Gamma
  distribution. } \item{ \code{beta}: Optimized rate paramter of the Gamma
  distribution } \item{ \code{basis}: The basis object. } \item{\code{lb}:
  The lower bound vector.} \item{\code{labels}: Cluster assignment labels.}
  \item{ \code{pi_k}: Expected value of mixing proportions.} }
}
\description{
General purpose functions for clustering latent profiles for
  different observation models using Variational Bayes (VB) EM-like
  algorithm.
}
\section{Details}{
 The modelling and mathematical details for clustering
  profiles using mean-field variational inference are explained here:
  \url{http://rpubs.com/cakapourani/} . More specifically: \itemize{\item{For
  Binomial/Bernoulli observation model check:
  \url{http://rpubs.com/cakapourani/vb-mixture-bpr}} \item{For Gaussian
  observation model check: \url{http://rpubs.com/cakapourani/vb-mixture-lr}}}
}

\examples{
# Example of optimizing parameters for synthetic data using 3 RBFs
basis <- create_rbf_object(M=3)
out <- cluster_profiles_vb(X = binomial_data, model = "binomial",
  basis=basis, vb_max_iter = 10)

#-------------------------------------

basis <- create_rbf_object(M=3)
out <- cluster_profiles_vb(X = gaussian_data, model = "gaussian",
  basis=basis, vb_max_iter = 10)

}
\seealso{
\code{\link{create_basis}}, \code{\link{cluster_profiles_mle}}
  \code{\link{infer_profiles_vb}}, \code{\link{infer_profiles_mle}},
  \code{\link{infer_profiles_gibbs}}, \code{\link{create_region_object}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
