% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_functions.R
\name{bpr_predict_wrap}
\alias{bpr_predict_wrap}
\title{(DEPRECATED) Predict gene expression from methylation profiles}
\usage{
bpr_predict_wrap(
  formula = NULL,
  x,
  y,
  model_name = "svm",
  w = NULL,
  basis = NULL,
  train_ind = NULL,
  train_perc = 0.7,
  fit_feature = "RMSE",
  cov_feature = TRUE,
  opt_method = "CG",
  opt_itnmax = 100,
  is_parallel = TRUE,
  no_cores = NULL,
  is_summary = TRUE
)
}
\arguments{
\item{formula}{An object of class \code{\link[stats]{formula}}, e.g. see
\code{\link[stats]{lm}} function. If NULL, the simple linear regression
model is used.}

\item{x}{The binomial distributed observations, which has to be a list of
elements of length N, where each element is an L x 3 matrix of
observations, where 1st column contains the locations. The 2nd and 3rd
columns contain the total trials and number of successes at the
corresponding locations, repsectively. See
\code{\link{process_haib_caltech_wrap}} on a possible way to get this data
structure.}

\item{y}{Corresponding gene expression data for each element of the list x.}

\item{model_name}{A string denoting the regression model. Currently,
available models are: \code{"svm"}, \code{"randomForest"}, \code{"rlm"},
\code{"mars"} and \code{"lm"}.}

\item{w}{Optional vector of initial parameter / coefficient values.}

\item{basis}{Optional basis function object, default is an 'rbf' object, see
\code{\link{create_rbf_object}}.}

\item{train_ind}{Optional vector containing the indices for the train set.}

\item{train_perc}{Optional parameter for defining the percentage of the
dataset to be used for training set, the remaining will be the test set.}

\item{fit_feature}{Return additional feature on how well the profile fits the
methylation data. Either NULL for ignoring this feature or one of the
following: 1) "RMSE" for returning the fit of the profile using the RMSE as
measure of error or 2) "NLL" for returning the fit of the profile using the
Negative Log Likelihood as measure of error.}

\item{cov_feature}{Logical, whether to return an additional feature for the
CpG coverage across the promoter region.}

\item{opt_method}{The optimization method to be used. See
\code{\link[stats]{optim}} for possible methods. Default is "CG".}

\item{opt_itnmax}{Optional argument giving the maximum number of iterations
for the corresponding method. See \code{\link[stats]{optim}} for details.}

\item{is_parallel}{Logical, indicating if code should be run in parallel.}

\item{no_cores}{Number of cores to be used, default is max_no_cores - 2.}

\item{is_summary}{Logical, print the summary statistics.}
}
\value{
A 'bpr_predict' object which, in addition to the input parameters,
  consists of the following variables: \itemize{ \item{ \code{W_opt}: An
  Nx(M+1) matrix with the optimized parameter values. Each row of the matrix
  corresponds to each element of the list x. The columns are of the same
  length as the parameter vector w (i.e. number of basis functions). } \item{
  \code{Mus}: An N x M matrix with the RBF centers if basis object is
  \code{\link{create_rbf_object}}, otherwise NULL.} \item{train}: The
  training data. \item{test}: The test data. \item \code{gex_model}: The
  fitted regression model. \item \code{train_pred} The predicted values for
  the training data. \item \code{test_pred} The predicted values for the test
  data. \item \code{train_errors}: The training error metrics. \item
  \code{test_errors}: The test error metrics.}
}
\description{
(DEPRECATED) \code{bpr_predict_wrap} is a function that wraps
  all the necessary subroutines for performing prediction on gene expression
  levels. Initially, it optimizes the parameters of the basis functions so as
  to learn the methylation profiles. Then, uses the learned parameters /
  coefficients of the basis functions as input features for performing
  regression in order to predict the corresponding gene expression levels.
}
\examples{
obs <- meth_data
y   <- gex_data
basis <- create_rbf_object(M = 5)
out   <- bpr_predict_wrap(x = obs, y = y, basis = basis,
                          is_parallel = FALSE, opt_itnmax = 3)

}
\seealso{
\code{\link{bpr_optimize}}, \code{\link{create_basis}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
