% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_functions.R
\name{bpr_optimize}
\alias{bpr_optimize}
\alias{bpr_optimise}
\alias{bpr_optim}
\alias{bpr_optim.list}
\alias{bpr_optim.matrix}
\title{(DEPRECATED) Optimize BPR negative log likelihood function}
\usage{
bpr_optim(x, ...)

\method{bpr_optim}{list}(
  x,
  w = NULL,
  basis = NULL,
  lambda = 1/2,
  opt_method = "CG",
  opt_itnmax = 100,
  is_parallel = TRUE,
  no_cores = NULL,
  ...
)

\method{bpr_optim}{matrix}(
  x,
  w = NULL,
  basis = NULL,
  lambda = 1/2,
  opt_method = "CG",
  opt_itnmax = 100,
  ...
)
}
\arguments{
\item{x}{The input object, either a \code{\link[base]{matrix}} or a
\code{\link[base]{list}}.}

\item{...}{Additional parameters.}

\item{w}{A vector of parameters (i.e. coefficients of the basis functions)}

\item{basis}{A 'basis' object. E.g. see \code{\link{create_rbf_object}}.}

\item{lambda}{The complexity penalty coefficient for ridge regression.}

\item{opt_method}{The optimization method to be used. See
\code{\link[stats]{optim}} for possible methods. Default is "CG".}

\item{opt_itnmax}{Optional argument giving the maximum number of iterations
for the corresponding method. See \code{\link[stats]{optim}} for details.}

\item{is_parallel}{Logical, indicating if code should be run in parallel.}

\item{no_cores}{Number of cores to be used, default is max_no_cores - 2.}
}
\value{
Depending on the input object \code{x}: \itemize{\item{If \code{x} is
  a \code{\link[base]{list}}:}  An object containing the following elements:
  \itemize{ \item{ \code{W_opt}: An Nx(M+1) matrix with the optimized
  parameter values. Each row of the matrix corresponds to each element of the
  list x. The columns are of the same length as the parameter vector w (i.e.
  number of basis functions). } \item{ \code{Mus}: An N x M matrix with the
  RBF centers if basis object is \code{\link{create_rbf_object}}, otherwise
  NULL.} \item{ \code{basis}: The basis object. } \item{ \code{w}: The
  initial values of the parameters w. } } \item{If \code{x} is a
  \code{\link[base]{matrix}}:} An object containing the following elements:
  \itemize{ \item{ \code{w_opt}: Optimized values for the coefficient vector
  w. The length of the result is the same as the length of the vector w. }
  \item{ \code{basis}: The basis object. } } \item{If calling
  \code{bpr_optim_fast} just the optimal weight matrix W_opt.} }
}
\description{
(DEPRECATED) The function bpr_optimize minimizes the negative
  log likelihood of the BPR function. Since it cannot be evaluated
  analytically, an optimization procedure is used. The
  \code{\link[stats]{optim}} packages is used for performing optimization.
}
\examples{
# Example of optimizing parameters for synthetic data using default values
data <- meth_data
out_opt <- bpr_optim(x = data, is_parallel = FALSE, opt_itnmax = 3)

#-------------------------------------

# Example of optimizing parameters for synthetic data using 3 RBFs
ex_data <- meth_data
basis <- create_rbf_object(M=3)
out_opt <- bpr_optim(x = ex_data, is_parallel = FALSE, basis = basis,
                     opt_itnmax = 3)

#-------------------------------------

# Example of of specific promoter region using 2 RBFs
basis <- create_rbf_object(M=2)
w <- c(0.1, 0.1, 0.1)
data <- meth_data[[1]]
out_opt <- bpr_optim(x = data, w = w, basis = basis, fit_feature = "NLL",
                     opt_itnmax = 3)

}
\seealso{
\code{\link{create_basis}}, \code{\link{eval_functions}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
