% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_functions.R
\name{bpr_cluster_wrap}
\alias{bpr_cluster_wrap}
\title{(DEPRECATED) Cluster methylation profiles}
\usage{
bpr_cluster_wrap(
  x,
  K = 3,
  pi_k = NULL,
  w = NULL,
  basis = NULL,
  em_max_iter = 100,
  epsilon_conv = 1e-04,
  lambda = 1/2,
  opt_method = "CG",
  opt_itnmax = 100,
  init_opt_itnmax = 100,
  is_parallel = TRUE,
  no_cores = NULL,
  is_verbose = FALSE
)
}
\arguments{
\item{x}{The binomial distributed observations, which has to be a list of
elements of length N, where each element is an L x 3 matrix of
observations, where 1st column contains the locations. The 2nd and 3rd
columns contain the total trials and number of successes at the
corresponding locations, repsectively. See
\code{\link{process_haib_caltech_wrap}} on a possible way to get this data
structure.}

\item{K}{Integer denoting the number of clusters K.}

\item{pi_k}{Mixing proportions.}

\item{w}{A MxK matrix, where each column consists of the basis function
coefficients for each corresponding cluster.}

\item{basis}{A 'basis' object. E.g. see \code{\link{create_rbf_object}}.}

\item{em_max_iter}{Integer denoting the maximum number of EM iterations.}

\item{epsilon_conv}{Numeric denoting the convergence parameter for EM.}

\item{lambda}{The complexity penalty coefficient for ridge regression.}

\item{opt_method}{The optimization method to be used. See
\code{\link[stats]{optim}} for possible methods. Default is "CG".}

\item{opt_itnmax}{Optional argument giving the maximum number of iterations
for the corresponding method. See \code{\link[stats]{optim}} for details.}

\item{init_opt_itnmax}{Optimization iterations for obtaining the initial EM
parameter values.}

\item{is_parallel}{Logical, indicating if code should be run in parallel.}

\item{no_cores}{Number of cores to be used, default is max_no_cores - 2.}

\item{is_verbose}{Logical, print results during EM iterations.}
}
\value{
A 'bpr_cluster' object which, in addition to the input parameters,
  consists of the following variables: \itemize{ \item{\code{pi_k}: Fitted
  mixing proportions.} \item{\code{w}: A MxK matrix with the fitted
  coefficients of the basis functions for each cluster k.} \item{\code{NLL}:
  The Negative Log Likelihood after the EM algorithm has finished.}
  \item{\code{r_nk}: Posterior probabilities of each promoter region
  belonging to each cluster.} \item{\code{labels}: Hard clustering
  assignments of each observation/promoter region.} \item{\code{BIC}:
  Bayesian Information Criterion metric.} \item{\code{AIC}: Akaike
  Information Criterion metric.} \item{\code{ICL}: Integrated Complete
  Likelihood criterion metric.} }
}
\description{
(DEPRECATED) \code{bpr_cluster_wrap} is a wrapper function that
  clusters methylation profiles using the EM algorithm. Initially, it
  performs parameter checking, and initializes main parameters, such as
  mixing proportions, basis function coefficients, then the EM algorithm is
  applied and finally model selection metrics are calculated, such as BIC and
  AIC.
}
\examples{
ex_data <- meth_data
data_clust <- bpr_cluster_wrap(x = ex_data, em_max_iter = 3, opt_itnmax = 3,
                               init_opt_itnmax = 5, is_parallel = FALSE)

}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
