% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{boxplot_cluster_expr}
\alias{boxplot_cluster_expr}
\title{Boxplot of clustered expression levels}
\usage{
boxplot_cluster_expr(cluster_obj, expr, anno, title = "Expression levels")
}
\arguments{
\item{cluster_obj}{The output from \code{\link{cluster_profiles_vb}} or
\code{\link{cluster_profiles_mle}} functions.}

\item{expr}{The expression data object.}

\item{anno}{The annotation data object.}

\item{title}{Plot title}
}
\value{
A ggplot2 object.
}
\description{
Create a boxplot of clustered gene expression levels which
  depend on the clustered methylation profiles. Each colour denotes a
  different cluster.
}
\examples{
# Cluster methylation profiles using 3 RBFs
basis <- create_rbf_object(M = 3)
# Perform clustering
cl_obj <- cluster_profiles_vb(X = encode_met$met, K = 3, model = "binomial",
           basis = basis, vb_max_iter = 5)
# Create plot
g <- boxplot_cluster_expr(cluster_obj = cl_obj, expr = encode_expr,
       anno = encode_met$anno)

}
\seealso{
\code{\link{plot_cluster_profiles}},
\code{\link{plot_infer_profiles}}, \code{\link{plot_predicted_expr}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
