% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotChrCluster.R
\name{PlotChrCluster}
\alias{PlotChrCluster}
\title{PlotChrCluster}
\usage{
PlotChrCluster(
  segs,
  clust_method = "ward.D2",
  plot_output = TRUE,
  plot_viewer = TRUE,
  plot_save = FALSE,
  plot_format = "png",
  plot_path,
  verbose = FALSE
)
}
\arguments{
\item{segs}{data.frame with segments of samples. It must be formatted with correct column names (start, end, ID)}

\item{clust_method}{clustering method. Default is "ward.D2"}

\item{plot_output}{Whether to plot refitted profiles (logical)}

\item{plot_viewer}{Logical parameter. When it is TRUE, the function print the output plot in the R viewer.By default is TRUE.}

\item{plot_save}{Logical parameter. When it is TRUE, the function save the plot in the chosen path and format. By default is TRUE.}

\item{plot_format}{File format for the output plots (accepts "png", "jpg", "pdf", "tiff"). By default is "png"}

\item{plot_path}{Path to save output plots.}

\item{verbose}{print information about the processes of the function. By default is FALSE}
}
\value{
Plot with chromosomes clustered
}
\description{
The function clusters chromosomes based on the copy number (CN) and returns a graph where it is possible to observe the different groups and two data frames (report and plot_table). See the vignette for the data frame descriptions.
}
\examples{
data(TCGA_BRCA_CN_segments)
Cluster <- PlotChrCluster(segs=TCGA_BRCA_CN_segments, 
                         clust_method= "ward.D2", 
                         plot_output=FALSE)
}
