% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DRrefit.R
\name{DRrefit}
\alias{DRrefit}
\title{DRrefit}
\usage{
DRrefit(
  segments_chort,
  chrlist,
  maxCN = 6,
  clust_method = "ward.D2",
  verbose = FALSE
)
}
\arguments{
\item{segments_chort}{data.frame formatted with correct column names}

\item{chrlist}{list of normal chromosome arms (pathology-specific)}

\item{maxCN}{threshold of max copy number to consider. By default is 6}

\item{clust_method}{clustering method. By default is "ward.D2"}

\item{verbose}{print information about the processes of the function. By default is FALSE}
}
\value{
Return two data frames, one is the DRrefit-corrected segments and the other is the samples report. See the vignette for data frame descriptions.
}
\description{
This function refits the diploid region of input copy number profiles (segments - BED file)
}
\examples{
data("TCGA_BRCA_CN_segments")

chr_list <- c("10q","11p","12p","19q","1p","21q","2q","3p","4p","4q","6p","6q","7p" )

results <- DRrefit(segments_chort = TCGA_BRCA_CN_segments, 
                   chrlist = chr_list)
}
