% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaAnalysis.R
\name{stoufferMethod}
\alias{stoufferMethod}
\title{Stouffer's method for meta-analysis}
\usage{
stoufferMethod(x)
}
\arguments{
\item{x}{is an array of independent p-values}
}
\value{
combined p-value
}
\description{
Combine independent studies using the sum of p-values 
transformed into standard normal variables
}
\details{
Considering a set of \emph{m} independent significance tests, the resulted 
p-values are independent and uniformly distributed between \emph{0} and 
\emph{1} under the null hypothesis. Stouffer's method is similar to 
Fisher's method (\link{fisherMethod}), with the difference is that it 
uses the sum of p-values transformed into standard normal variables 
instead of the log product.
}
\examples{

x <- rep(0,10)
stoufferMethod(x)

x <- runif(10)
stoufferMethod(x)

}
\author{
Tin Nguyen and Sorin Draghici
}
\references{
[1] S. Stouffer, E. Suchman, L. DeVinney, S. Star, and R. M. Williams. 
The American Soldier: Adjustment during army life, volume 1. 
Princeton University Press, Princeton, 1949.
}
\seealso{
\code{\link{fisherMethod}}, \code{\link{addCLT}}
}

