% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replaceOutsideValues.R
\name{replaceOutsideValues}
\alias{replaceOutsideValues}
\title{Replace DNA methylation values out of the boundaries}
\usage{
replaceOutsideValues(data)
}
\arguments{
\item{data}{any matrix filled with values that normally should be bounded
between 0 and 1.}
}
\value{
Returns the input matrix with every value previously below 0 changed
to 0 and every value previously beyond 1 changed to 1.
}
\description{
A method which replaces values below 0 or beyond 1 contained in
the input matrix. These wrong entries are replaced by 0 or 1, respectively.
Note that this method is especially designed for DNA methylation data.
}
\details{
replaceOutsideValues

Note that this method is especially designed to run after the batch
effect correction of DNA methylation data, e.g. with the
\code{\link{imputeMissingData}} method. It can happen, that the predicted
values are lying slightly below the lower bound of 0 or beyond the upper
bound of 1. This method finds these inaccurately predicted entries. Another
method called \code{\link{replaceOutsideValues}} replaces these values either
by 0 or 1, respectively. Another method called \code{\link{findOutsideValues}}
returns a list of existing wrong values and can be run before the
replacement.
}
\examples{
data(BEclearCorrected)
# Replace wrongly predicted values
corrected <- replaceOutsideValues(data = ex.corrected.data)
}
\seealso{
\code{\link{findOutsideValues}}

\code{\link{correctBatchEffect}}
}
