% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessBEclear.R
\name{preprocessBEclear}
\alias{preprocessBEclear}
\title{preprocessBEclear}
\usage{
preprocessBEclear(data, samples)
}
\arguments{
\item{data}{any matrix filled with beta values, column names have to be
sample_ids corresponding to the ids listed in "samples", row names have to
be gene names.}

\item{samples}{data frame with two columns, the first column has to contain
the sample numbers, the second column has to contain the corresponding batch
number. Colnames have to be named as "sample_id" and "batch_id".}
}
\value{
a list containing the processed data and samples and a 
\code{\link[data.table]{data.table}} containing mappings from the original
sample names to the new ones. If sample names weren't changed this third
object is \code{NULL}
}
\description{
this methods does some preprocessing steps for the later methods
like removing rows containing only missing values
}
\details{
Here we describe the preprocessing steps in the order they are executed:
\itemize{
\item{Values below 0 or above 1 are set to \code{NA}, as the other methods 
expect methylation beta values}
\item{columns that only contain \code{NA}s are removed}
\item{rows that only contain \code{NA}s are removed}
\item{samples that are present in the data, but are not annoted in the samples 
are removed. If this is the case with your data-set, please check those samples.}
\item{samples that are annoted but not in the data matrix are removed}
\item{if there are duplicate sample names in the data matrix, all sample names
get replaced through a new unique ID. In this case a \code{\link[data.table]{data.table}}
containing the mapping is returned as well}
}
}
\examples{
data(BEclearData)
res <- preprocessBEclear(ex.data, ex.samples)
}
