% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countValuesToPredict.R
\name{countValuesToPredict}
\alias{countValuesToPredict}
\title{Count NA entries in a matrix}
\usage{
countValuesToPredict(data)
}
\arguments{
\item{data}{any kind of matrix}
}
\value{
Returns a data frame with the number of NA entries per column. Since
the function is mainly written for the usage in batch effect correction of
DNA methylation data, the column names of the data frame are set to "sample"
and "num_pred_values". Nevertheless, the function can be used with any other
matrix containing anything but beta values.
}
\description{
Simple function that counts all values in a matrix which are NA
}
\details{
countValuesToPredict
}
\examples{
## Shortly running example. For a more realistic example that takes
## some more time, run the same procedure with the full BEclearData
## dataset

## Whole procedure that has to be done to use this function.
data(BEclearData)
ex.data <- ex.data[31:90, 7:26]
ex.samples <- ex.samples[7:26, ]

## Calculate the batch effects
batchEffects <- calcBatchEffects(data = ex.data, samples = ex.samples,
adjusted = TRUE, method = "fdr")
meds <- batchEffects$med
pvals <- batchEffects$pval

## Summarize p-values and median differences for batch affected genes
sum <- calcSummary(medians = meds, pvalues = pvals)
clearedMatrix <- clearBEgenes(data = ex.data, samples = ex.samples, summary = sum)
numberOfEntries <- countValuesToPredict(data = clearedMatrix)
}
\seealso{
\code{\link{clearBEgenes}}

\code{\link{correctBatchEffect}}

\code{\link{correctBatchEffect}}
}
