% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_Dataset.R
\name{generate_data_covariables}
\alias{generate_data_covariables}
\title{Generate dataset with batch-effects and 2 classes with a specified imbalance.}
\usage{
generate_data_covariables(
  features,
  batches,
  samplesperbatch,
  mvstmt,
  imbalcov,
  housekeeping = NULL
)
}
\arguments{
\item{features}{Integer indicating the number of features
(e.g. genes/proteins) in the dataset.}

\item{batches}{Integer indicating the number of batches in the
dataset.}

\item{samplesperbatch}{Integer indicating the number of of samples
per batch.}

\item{mvstmt}{Float (in [0,1)) indicating the fraction of missing values
per batch.}

\item{imbalcov}{Float indicating the probability for one of the classes to be
drawn as class label for each sample. The second class will have
probability of 1-imbalcov}

\item{housekeeping}{If NULL, no huosekeeping features will be simulatd.
Else, housepeeping indicates the fraction of of housekeeping features.}
}
\value{
A dataframe containing the simulated data. Column Cov_1 will contain
the simulated, imbalanced labels.
}
\description{
The data will be already in the correct format for BERT.
}
\examples{
# generate dataset with 1000 features, 5 batches, 10 samples per batch and
# two genotypes. The class ratio will either be 7:3 or 3:7 per batch.
data = generate_data_covariables(1000,5,10, 0.1, 0.3)
}
