% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_precision.R
\name{plot_precision}
\alias{plot_precision}
\title{Plot the log-precision estimates}
\usage{
plot_precision(prior)
}
\arguments{
\item{prior}{the prior of the log-precision parameter, computed via \code{\link{prior_precision}}.}
}
\value{
A plot.
}
\description{
\code{\link{plot_precision}} plots a histogram of the estimates for the log-precision parameter 
of the Dirichlet-Multinomial distribution, obtained via \code{\link{prior_precision}}.
The solid line represents the normal prior for the log-precision parameter.
}
\examples{
# load the pre-computed precision estimates:
data(precision, package = "BANDITS")

# Plot the histogram of the genewise log-precision estimates.
# The black solid line represents the normally distributed prior distribution 
# for the log-precision parameter.
plot_precision(precision)

}
\seealso{
\code{\link{test_DTU}}, \code{\link{prior_precision}}
}
\author{
Simone Tiberi \email{simone.tiberi@uzh.ch}
}
