\name{plotLinear}
\alias{plotLinear}
\title{Plot linear model for sequins}
\description{
Create linear model for sequins, between input concentation on the x-axis and
measurment on the y-axis.
}
\usage{
plotLinear(seqs, x, y, std, title, xlab, ylab, showSD, showLOQ, showStats,
           xBreaks, yBreaks, errors, showLinear, showAxis)
}
\arguments{
  \item{seqs}{Sequin names}
  \item{x}{Input concentration on the x-axis}
  \item{y}{Measurement on the y-axis}
  \item{std}{Standard deviation. (Default to \code{NULL}).}  
  \item{title}{Label of the plot. (Default to \code{NULL}).}
  \item{xlab}{Label for the x-axis. (Default to \code{NULL}).}
  \item{ylab}{Label for the y-axis. (Default to \code{NULL}).}
  \item{xBreaks}{Breaks for the x-axis. (Default to \code{NULL}).}
  \item{yBreaks}{Breaks for the y-axis. (Default to \code{NULL}).}
  \item{showSD}{Display vertical standard deviation bars. (Default to \code{FALSE}).}
  \item{showLOQ}{Display limit-of-quantification? Default to \code{TRUE}.}
  \item{showStats}{Display regression statistics? Default to \code{TRUE}.}  
  \item{errors}{How errors bar should be calculated. \code{SD} or \code{Range}.}
  \item{showLinear}{Display regression line. (Default to \code{TRUE}).}
  \item{showAxis}{Display x-axis and y-axis. (Default to \code{TRUE}).}
}
\details{
The \code{plotLinear} function plots a scatter plot with input concentration on
the x-axis, and measurement on the y-axis. The input concentration is
typically the concentration level in ladder mixture, although other
measures (such as expected copy number) are also possible. The function
builds a linear regression between the two variables, and reports associated
statistics (R2, correlation and regression parameters) on the plot.

The function also estimates limit-of-quantification (LOQ) breakpoint, and
reports it on the plot if found. LOQ is defined as the lowest empirical
detection limit, a threshold value beyond which stochastic behavior occur.
LOQ is estimated by fitting segmented linear regression with two segments
on the entire data set, while minimizing the total sum of squares of the
differences between the variables. 
}
\value{
The function prints a scatter plot and return it's LOQ statistics.
}
\examples{
library(Anaquin)

#
# Data set generated by Cufflinks and Anaquin. described in Section 5.4.6.3 of
# the user guide.
#
data(UserGuideData_5.4.6.3)

title <- 'Gene Expression'
xlab  <- 'Input Concentration (log2)'
ylab  <- 'FPKM (log2)'

# Sequin names
seqs <- row.names(UserGuideData_5.4.6.3)

# Input concentration
x <- log2(UserGuideData_5.4.6.3$Input)

# Measured FPKM
y <- log2(UserGuideData_5.4.6.3[,2:4])

plotLinear(seqs, x, y, title=title, xlab=xlab, ylab=ylab, showLOQ=TRUE)
}

\author{Ted Wong \email{t.wong@garvan.org.au}}