\name{plotLOD}
\alias{plotLOD}
\title{Create Limit-of-Detection Ratio (LOD) plot}
\description{
Create Limit-of-Detection Ratio (LOD) plot between measured abundance
(x-axis) and p-value probability (y-axis).
}
\usage{
plotLOD(measured, pval, ratio, qval, FDR, title, xlab, ylab, legTitle, showConf)
}
\arguments{
  \item{measured}{Measured abundance}
  \item{pval}{P-value probability}
  \item{ratio}{How to group ROC points}
  \item{qval}{Q-value probability. (Default to \code{NULL}).}  
  \item{FDR}{Chosen false-discovery-rate. Default to \code{NULL}).}
  \item{title}{Title of the plot. (Default to \code{NULL}).}
  \item{xlab}{Label for the x-axis. (Default to \code{NULL}).}
  \item{ylab}{Label for the y-axis. (Default to \code{NULL}).}
  \item{legTitle}{Title for the legend. (Default to \code{'Ratio'}).}
  \item{showConf}{Display confidence interval. (Default to \code{FALSE}).}
}
\details{
Create a Limit-of-Detection Ratio (LOD) plot between measured abundance
(x-axis) and p-value probability (y-axis).

The LOD plot indicates the confidence in measurement relative to the magnitude
of the measurement. For example, p-value should converge to zero as the
sequencing depth increases.

The function also fits non-parametric curves for each sequin ratio group. The
curves are modelled with local regression analysis, and are colored by the
sequin group.

plotLODR is a simplification from the ERCC dashboard R-package.
Further details on the statistical algorithm is available in the ERCC
documentation at
https://bioconductor.org/packages/release/bioc/html/erccdashboard.html.
}

\value{
The function prints a LODR plot and return associated statistics.
}

\examples{
library(Anaquin)

#
# Data set generated by DESeq2 and Anaquin. described in Section 5.6.3.3 of
# the user guide.
#
data(UserGuideData_5.6.3)

xlab  <- 'Average Counts'
ylab  <- 'P-value'
title <- 'LOD Curves'

# Sequin names
seqs <- row.names(UserGuideData_5.6.3)

# Expected log-fold
group <- UserGuideData_5.6.3$ExpLFC

# Measured average abundance
measured <- UserGuideData_5.6.3$Mean

# P-value
pval <- UserGuideData_5.6.3$Pval

# Q-value
qval <- UserGuideData_5.6.3$Qval

plotLOD(measured, pval, group, qval, xlab=xlab, ylab=ylab, title=title, FDR=0.1)
}

\author{Ted Wong \email{t.wong@garvan.org.au}}