% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableAnalysis.R
\name{availableAnalysis}
\alias{availableAnalysis}
\title{Find the available analysis}
\usage{
availableAnalysis(curatedOnly = TRUE, keyword = NULL)
}
\arguments{
\item{curatedOnly}{Default is \code{TRUE}, returning only workspaces that
offer simplified input configuration by this package. If it is set to
\code{FALSE}, all the workspaces}

\item{keyword}{Default is \code{NULL}. When this argument is provided as
a character(1), it will return only the workspaces containing the keyword
and the user has an access to.}
}
\value{
A data frame. The \code{analysis} columns shows the name of the
available analyses, which is the required input (\code{analysis} argument)
for the functions implemented in AnVILWorkflow package.
}
\description{
This function shows the available analyses and the brief
descriptions of them.
}
\examples{
library(AnVILBase)
if (has_avworkspace(strict = TRUE, platform = AnVILGCP::gcp())) {
    availableAnalysis()
}

}
