% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcp-methods.R
\name{gcp-methods}
\alias{gcp-methods}
\alias{avcopy}
\alias{avlist}
\alias{avremove}
\alias{avbackup}
\alias{avrestore}
\alias{avstorage}
\alias{avcopy,gcp-method}
\alias{avlist,gcp-method}
\alias{avremove,gcp-method}
\alias{avbackup,gcp-method}
\alias{avrestore,gcp-method}
\alias{avstorage,gcp-method}
\title{Methods compatible with the GCP platform class}
\usage{
\S4method{avcopy}{gcp}(
  source,
  destination,
  ...,
  recursive = FALSE,
  parallel = TRUE,
  platform = cloud_platform()
)

\S4method{avlist}{gcp}(
  source = character(),
  recursive = FALSE,
  ...,
  platform = cloud_platform()
)

\S4method{avremove}{gcp}(
  source,
  recursive = FALSE,
  force = FALSE,
  parallel = TRUE,
  ...,
  platform = cloud_platform()
)

\S4method{avbackup}{gcp}(
  source,
  destination,
  recursive = FALSE,
  exclude = NULL,
  dry = TRUE,
  delete = FALSE,
  parallel = TRUE,
  ...,
  platform = cloud_platform()
)

\S4method{avrestore}{gcp}(
  source,
  destination,
  recursive = FALSE,
  exclude = NULL,
  dry = TRUE,
  delete = FALSE,
  parallel = TRUE,
  ...,
  platform = cloud_platform()
)

\S4method{avstorage}{gcp}(
  namespace = avworkspace_namespace(),
  name = avworkspace_name(),
  ...,
  platform = cloud_platform()
)
}
\arguments{
\item{source}{\code{character(1)}, (\code{character()} for \code{avlist()}, \code{avcopy()})
paths to a google storage bucket, possibly with wild-cards for file-level
pattern matching.}

\item{destination}{\code{character(1)}, google cloud bucket or local file system
destination path.}

\item{...}{additional arguments passed as-is to the \code{gsutil} subcommand.}

\item{recursive}{\code{logical(1)}; perform operation recursively from \code{source}?.
Default: \code{FALSE}.}

\item{parallel}{\code{logical(1)}, perform parallel multi-threaded /
multi-processing (default is \code{TRUE}).}

\item{platform}{\code{gcp()} The cloud platform class to dispatch on as given by
\link[AnVILBase:cloud_platform]{AnVILBase::cloud_platform}. Typically not set manually as
\code{cloud_platform()} returns the \code{"gcp"} class for Google Cloud Platform
workspaces on AnVIL.}

\item{force}{\code{logical(1)}: continue silently despite errors when
removing multiple objects. Default: \code{FALSE}.}

\item{exclude}{\code{character(1)} a python regular expression of bucket
paths to exclude from synchronization. E.g.,
\verb{'.*(\\\\.png|\\\\.txt)$"} excludes '.png' and .txt' files.}

\item{dry}{\code{logical(1)}, when \code{TRUE} (default), return the
consequences of the operation without actually performing the
operation.}

\item{delete}{\code{logical(1)}, when \code{TRUE}, remove files in
\code{destination} that are not in \code{source}. Exercise caution when
you use this option: it's possible to delete large amounts of
data accidentally if, for example, you erroneously reverse
source and destination.}

\item{namespace}{\code{character(1)} AnVIL workspace namespace as returned
by, e.g., \code{avworkspace_namespace()}}

\item{name}{\code{character(1)} AnVIL workspace name as returned by, e.g.,
\code{avworkspace_name()}.}
}
\value{
\code{avcopy()}: exit status of \code{avcopy()}, invisibly.
\code{avlist()}: \code{character()} listing of \code{source} content.
\code{avremove()}: exit status of \verb{gsutil rm}, invisibly.
\code{avbackup()}: exit status of \verb{gsutil rsync}, invisbly.
\code{avrestore()}: exit status of \verb{gsutil rsync}, invisbly.
\code{avstorage()} returns a \code{character(1)} bucket identifier prefixed with
\verb{gs://}
}
\description{
\code{avcopy()}: copy contents of \code{source} to \code{destination}. At
least one of \code{source} or \code{destination} must be Google cloud bucket;
\code{source} can be a character vector with length greater than 1. Use
\code{gsutil_help("cp")} for \code{gsutil} help.

\code{avlist()}: List contents of a google cloud bucket or, if \code{source} is
missing, all Cloud Storage buckets under your default project ID

\code{avremove()}: remove contents of a Google Cloud Bucket.

\code{avbackup()},\code{avrestore()}: synchronize a source and a destination. If the
destination is on the local file system, it must be a directory or not yet
exist (in which case a directory will be created).

\code{avstorage()} returns the workspace bucket, i.e., the google bucket
associated with a workspace. Bucket content can be visualized under the
'DATA' tab, 'Files' item.

\code{avworkspaces()}: returns a tibble with columns including the name, last
modification time, namespace, and owner status.

\code{avtable_import()}: returns a \code{tibble()} containing the page number, 'from'
and 'to' rows included in the page, job identifier, initial status of the
uploaded 'chunks', and any (error) messages generated during status check.
Use \code{avtable_import_status()} to query current status.
}
\details{
\verb{avbackup()': To make }"gs://mybucket/data"\verb{match the contents of the local directory}"data"` you could do:

\code{avbackup("data", "gs://mybucket/data", delete = TRUE)}

To make the local directory "data" the same as the contents of
gs://mybucket/data:

\code{avrestore("gs://mybucket/data", "data", delete = TRUE)}

If \code{destination} is a local path and does not exist, it will be
created.
}
\section{Functions}{
\itemize{
\item \code{avcopy(gcp)}: copy contents of \code{source} to \code{destination} with
\code{gsutil}

\item \code{avlist(gcp)}: list contents of \code{source} with \code{gsutil}

\item \code{avremove(gcp)}: remove contents of \code{source} with \code{gsutil}

\item \code{avbackup(gcp)}: backup contents of \code{source} with \code{gsutil}

\item \code{avrestore(gcp)}: restore contents of \code{source} with \code{gsutil}

\item \code{avstorage(gcp)}: get the storage bucket location

}}
\examples{
src <-
   "gs://genomics-public-data/1000-genomes/other/sample_info/sample_info.csv"
if (has_avworkspace(platform = gcp())) {
   avcopy(src, tempdir())
   ## internal gsutil_*() commands work with spaces in source or destination
   destination <- file.path(tempdir(), "foo bar")
   avcopy(src, destination)
   file.exists(destination)
}
if (has_avworkspace(strict = TRUE, platform = gcp()))
    ## From within AnVIL...
    bucket <- avstorage()                        # discover bucket

if (has_avworkspace(strict = TRUE, platform = gcp()) && interactive()) {
    path <- file.path(bucket, "mtcars.tab")
    avlist(dirname(path))                    # no 'mtcars.tab'...
    write.table(mtcars, gsutil_pipe(path, "w")) # write to bucket
    gsutil_stat(path)                           # yep, there!
    read.table(gsutil_pipe(path, "r"))          # read from bucket
}
}
