% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Billing.R
\name{getBilling}
\alias{getBilling}
\title{request billing data}
\usage{
getBilling(
  startDate,
  endDate,
  bqProject,
  bqDataset,
  bqTable,
  bqBilling_code,
  page_size = 50000
)
}
\arguments{
\item{startDate}{character(1) date of start of reckoning}

\item{endDate}{character(1) date of end of reckoning}

\item{bqProject}{character(1) GCP project id}

\item{bqDataset}{character(1) GCP dataset id for billing data in BQ}

\item{bqTable}{character(1) GCP table for billing data in BQ}

\item{bqBilling_code}{character(1) GCP billing code}

\item{page_size}{numeric(1) passed to dbConnect}
}
\value{
tbl_df
}
\description{
request billing data
}
\note{
On 21 August 2020 VJC changed condition on endDate to <=
}
\examples{
if (interactive()) {
getBilling(startDate="2020-08-01", 
   endDate="2020-08-15", bqProject="bjbilling", 
   bqTable="gcp_billing_export_v1_015E39_38569D_3CC771",  
   bqDataset="anvilbilling", bqBilling_code="landmarkanvil2")
}
}
