% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloud_platform.R
\name{cloud_platform}
\alias{cloud_platform}
\alias{avplatform_namespace}
\title{Cloud Platform Identifier}
\usage{
avplatform_namespace(default = "")

cloud_platform()
}
\arguments{
\item{default}{\code{character(1)}. The default cloud platform to use if no
environment variables or options are set. The default is \code{""}.}
}
\value{
For \code{avplatform_namespace}: A character string indicating the cloud
platform derived from environment variables.

For \code{cloud_platform}: An instance of class \code{gcp} or \code{azure} based on
environment variables or options set within the AnVIL workspace. For
\code{avplatform_namespace}: A character string indicating the cloud platform.
}
\description{
\code{cloud_platform} calls the appropriate class constructor based
on environment variables or options within the workspace. This function is
used to determine the cloud platform to dispatch on for AnVIL methods. It
returns an error when neither the Azure or Google Cloud environment
variables are set. The \code{avplatform_namespace} function is a lower level
helper to identify the platform based on environment variables or options.
Generally, these functions are \emph{not} meant to be used directly.
}
\details{
When \code{GOOGLE_PROJECT} is set, the function returns an object of
class \code{gcp}. When \code{WORKSPACE_ID} is set, the function returns an object of
class \code{azure}. Otherwise, the function returns an error. The user may also
add options to set a default cloud platform. For AnVIL instances running on
Google Cloud, the user can set
\code{options(GCLOUD_SDK_PATH = "/home/user/google-cloud-sdk")}
to set the default cloud platform to \code{gcp}. For AnVIL instances running on
Azure, the user can set \code{options(AnVILAz.workspace_id = "myworkspace")}
to set the default cloud platform to \code{azure}. Note that the values provided
are example values and should be replaced with verifiable values.
}
\examples{
avplatform_namespace()
if (interactive()) {
    cloud_platform()
}
}
