% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avworkflow-methods.R
\name{avworkflow-methods}
\alias{avworkflow-methods}
\alias{avworkflow_jobs,missing-method}
\alias{avworkflow_jobs,ANY-method}
\title{All the workflow type methods for AnVIL}
\usage{
\S4method{avworkflow_jobs}{missing}(..., platform)

\S4method{avworkflow_jobs}{ANY}(..., platform)
}
\arguments{
\item{...}{Arguments passed to the methods.}

\item{platform}{A Platform derived class indicating the AnVIL environment,
currently, \code{azure} and \code{gcp} classes are compatible.}
}
\value{
Methods for the 'missing' and 'ANY' signatures provide a way to
redirect calls to the appropriate method for the current cloud platform.
}
\description{
These are the methods to be used by the AnVIL package.
}
\section{Functions}{
\itemize{
\item \code{avworkflow_jobs(missing)}: Get the status of a workflow execution

\item \code{avworkflow_jobs(ANY)}: Get the status of a workflow execution

}}
\examples{
findMethods("avworkflow_jobs")
getMethod("avworkflow_jobs", c(platform = "missing"))

}
