% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avtable-methods.R
\name{avtable-methods}
\alias{avtable-methods}
\alias{avtable}
\alias{avtables}
\alias{avtable_import}
\alias{avtable_import_set}
\alias{avtable_delete}
\alias{avtable_delete_values}
\alias{avtable,azure-method}
\alias{avtables,azure-method}
\alias{avtable_import,azure-method}
\alias{avtable_import_set,azure-method}
\alias{avtable_delete,azure-method}
\alias{avtable_delete_values,azure-method}
\title{AnVIL Azure table ("type") methods}
\usage{
\S4method{avtable}{azure}(table, ..., platform = cloud_platform())

\S4method{avtables}{azure}(..., platform = cloud_platform())

\S4method{avtable_import}{azure}(
  .data,
  table,
  entity = names(.data)[[1L]],
  ...,
  platform = cloud_platform()
)

\S4method{avtable_import_set}{azure}(
  .data,
  origin,
  set = names(.data)[[1]],
  member = names(.data)[[2]],
  ...,
  platform = cloud_platform()
)

\S4method{avtable_delete}{azure}(table, ..., platform = cloud_platform())

\S4method{avtable_delete_values}{azure}(table, values, ..., platform = cloud_platform())
}
\arguments{
\item{table}{\code{character(1)} The name of the table / type}

\item{...}{Additional arguments passed to lower level functions (not used)}

\item{platform}{\code{azure()} The cloud platform class to dispatch on as given by
\link[AnVILBase:cloud_platform]{AnVILBase::cloud_platform}. Typically not set manually as
\code{cloud_platform()} returns the \code{"azure"} class for Azure workspaces on
AnVIL.}

\item{.data}{\code{tibble()} The dataset chiefly from the \code{avtable()} operation}

\item{entity}{The entity name, i.e., the name of the column in the table that
provides the keys for the data (a.k.a. \code{primaryKey}). By default, the first
column in the table. The keys cannot contain special characters or spaces.}

\item{origin}{\code{character(1)} name of the type (entity table) used to create
the set e.g "sample", "participant", etc.}

\item{set}{\code{character(1)} column name of \code{.data} identifying the set(s) to be
created, i.e., the grouping variable.}

\item{member}{\code{character(1)} column name of \code{.data} identifying the member(s)
of the set(s) or groups. The values in this column may repeat if
an ID is in more than one set.}

\item{values}{\code{character()} vector of \code{primaryKey} values corresponding to
rows to be deleted}
}
\value{
\code{avtable}: a \code{tibble()} corresponding to the data with the name as
given by \code{table}

\code{avtables}: a \code{tibble()} with columns \code{table}, \code{count}, and
\code{colnames} corresponding to the tables / types available in the current
workspace

\code{avtable_import()}: called for the side effect of uploading the data
to the DATA tab

\code{avtable_import_set()}: a \code{character(1)} name of the imported
tibble.

\code{avtable_delete}: a \code{logical(1)} indicating success or failure

\code{avtable_delete_values()}: a \code{logical(1)} vector indicating success
or failure for each value in \code{values}
}
\description{
Methods for working with AnVIL Azure tables. These are referred
to as "types" in the AnVIL Workspace Data Service (WDS) API.
}
\details{
\code{avtable_import_set()} creates new rows in a table \verb{<origin>_set}.
One row will be created for each distinct value in the column identified by
\code{set}. Each row entry has a corresponding column \verb{<origin>} linking to one
or more rows in the \verb{<origin>} table, as given in the \code{member} column. The
operation is somewhat like \code{split(member, set)}.
}
\section{Functions}{
\itemize{
\item \code{avtable(azure)}: List the contents of a particular table / type

\item \code{avtables(azure)}: List the available tables / types

\item \code{avtable_import(azure)}: Upload a dataset to the DATA tab

\item \code{avtable_import_set(azure)}: Create a grouping table from an origin dataset

\item \code{avtable_delete(azure)}: Delete a table / type

\item \code{avtable_delete_values(azure)}: Delete rows from a table / type

}}
\examples{
if (interactive()) {
  library(dplyr)
  mtcars_tbl <-
      mtcars |>
      as_tibble(rownames = "model_id") |>
      mutate(model_id = gsub(" ", "-", model_id))

  avtable_import(
    mtcars_tbl,
    table = "testData",
    entity = "model_id"
  )

  avtable("testData")

  avtable("testData") |>                  # new 'testData_set' table
        avtable_import_set("testData", "cyl", "model_id")

  avtable_delete("testData_set")

  avtable_delete_values("testData", "Mazda-RX4")
}
}
