% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{to_ASICS}
\alias{to_ASICS}
\title{Export data for the ASICS spectral quantification library}
\usage{
to_ASICS(dataset, ...)
}
\arguments{
\item{dataset}{An \link{nmr_dataset_1D} object}

\item{...}{
  Arguments passed on to \code{\link[ASICS:createSpectra]{ASICS::createSpectra}}
  \describe{
    \item{\code{norm.method}}{Character specifying the normalisation method to use on
spectra ONLY if the \code{\link[ASICS]{importSpectra}} function was not used.}
    \item{\code{norm.params}}{List containing normalisation parameteres (see
\code{\link[ASICS]{normaliseSpectra}} for details) ONLY if the
\code{\link[ASICS]{importSpectra}} function was not used.}
  }}
}
\value{
An \link[ASICS:Spectra-class]{ASICS::Spectra} object
}
\description{
Exports the spectra matrix, sample names and chemical shift axis into
an ASICS Spectra object.
}
\examples{
if (requireNamespace("ASICS", quietly=TRUE)) {
  nsamp <- 3
  npoints <- 300
  metadata <- list(external = data.frame(
    NMRExperiment = paste0("Sample", seq_len(nsamp))
  ))
  dataset <- new_nmr_dataset_1D(
    ppm_axis = seq(from = 0.2, to = 10, length.out = npoints),
    data_1r = matrix(runif(nsamp * npoints), nrow = nsamp, ncol = npoints),
    metadata = metadata
  )
  forAsics <- to_ASICS(dataset)
  #ASICS::ASICS(forAsics)
}
}
