% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_dataset_peak_table.R
\name{[.nmr_dataset_peak_table}
\alias{[.nmr_dataset_peak_table}
\title{Extract parts of an nmr_dataset_peak_table}
\usage{
\method{[}{nmr_dataset_peak_table}(x, i)
}
\arguments{
\item{x}{an \link{nmr_dataset_peak_table} object}

\item{i}{indices of the samples to keep}
}
\value{
an nmr_dataset_peak_table with the extracted samples
}
\description{
Extract parts of an nmr_dataset_peak_table
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -0.5, max = 10, by = 2.3E-4))
meta <- file.path(dir_to_demo_dataset, "dummy_metadata.xlsx")
metadata <- readxl::read_excel(meta, sheet = 1)
dataset_1D <- nmr_meta_add(dataset_1D, metadata = metadata, by = "NMRExperiment")
metadata <- list(external = dataset_1D[["metadata"]][["external"]])
peak_table <- nmr_data(dataset_1D)
new <- new_nmr_dataset_peak_table(peak_table, metadata)
new[0]
}
\seealso{
Other subsetting functions: 
\code{\link{[.nmr_dataset}()},
\code{\link{[.nmr_dataset_1D}()},
\code{\link{filter.nmr_dataset_family}()},
\code{\link{nmr_pca_outliers_filter}()}
}
\concept{subsetting functions}
