% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_dataset_1D.R
\name{[.nmr_dataset_1D}
\alias{[.nmr_dataset_1D}
\title{Extract parts of an nmr_dataset_1D}
\usage{
\method{[}{nmr_dataset_1D}(x, i)
}
\arguments{
\item{x}{an \link{nmr_dataset_1D} object}

\item{i}{indices of the samples to keep}
}
\value{
an nmr_dataset_1D with the extracted samples
}
\description{
Extract parts of an nmr_dataset_1D
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -0.5, max = 10, by = 2.3E-4))
dataset_1D[0]
}
\seealso{
Other subsetting functions: 
\code{\link{[.nmr_dataset}()},
\code{\link{[.nmr_dataset_peak_table}()},
\code{\link{filter.nmr_dataset_family}()},
\code{\link{nmr_pca_outliers_filter}()}

Other nmr_dataset_1D functions: 
\code{\link{format.nmr_dataset_1D}()},
\code{\link{get_integration_with_metadata}()},
\code{\link{is.nmr_dataset_1D}()},
\code{\link{nmr_integrate_peak_positions}()},
\code{\link{nmr_integrate_regions}()},
\code{\link{nmr_meta_add}()},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_meta_get}()},
\code{\link{nmr_meta_get_column}()},
\code{\link{nmr_ppm_resolution}()},
\code{\link{print.nmr_dataset_1D}()}
}
\concept{nmr_dataset_1D functions}
\concept{subsetting functions}
