% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_webgl}
\alias{plot_webgl}
\title{Plot a dataset into a HTML file}
\usage{
plot_webgl(nmr_dataset, html_filename, overwrite = NULL, ...)
}
\arguments{
\item{nmr_dataset}{An \link{nmr_dataset_1D}}

\item{html_filename}{The output HTML filename to be created}

\item{overwrite}{Overwrite the lib/ directory (use \code{NULL} to prompt the user)}

\item{...}{
  Arguments passed on to \code{\link[=plot.nmr_dataset_1D]{plot.nmr_dataset_1D}}
  \describe{
    \item{\code{x}}{a \link{nmr_dataset_1D} object}
    \item{\code{chemshift_range}}{range of the chemical shifts to be included. Can be of length 3
to include the resolution in the third element (e.g. \code{c(0.2, 0.8, 0.005)})}
    \item{\code{NMRExperiment}}{A character vector with the NMRExperiments to include. Use "all" to include all experiments.}
    \item{\code{quantile_plot}}{If \code{TRUE} plot the 10\\%, 50\\%, 90\\% percentiles of the spectra as reference.
If two numbers between 0 and 1 are given then a custom percentile can be plotted}
    \item{\code{quantile_colors}}{A vector with the colors for each of the quantiles}
    \item{\code{interactive}}{if \code{TRUE} return an interactive plotly plot, otherwise return a ggplot one.}
  }}
}
\value{
the html filename created
}
\description{
Uses WebGL for performance
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
# dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
# dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -0.5, max = 10, by = 2.3E-4))
# html_plot <- plot_webgl(dataset_1D, "html_plot.html")

}
\concept{plotting nmr datasets}
