% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/area_estimation.R
\name{peaklist_fit_lorentzians}
\alias{peaklist_fit_lorentzians}
\title{Fit lorentzians to each peak to estimate areas}
\usage{
peaklist_fit_lorentzians(
  peak_data,
  nmr_dataset,
  amplitude_method = c("intensity", "2nd_derivative", "intensity_without_baseline"),
  refine_peak_model = c("none", "peak", "2nd_derivative")
)
}
\arguments{
\item{peak_data}{The peak data}

\item{nmr_dataset}{The nmr_dataset object with the data. This function for now assumes nmr_dataset is NOT be baseline corrected}

\item{amplitude_method}{The method to estimate the amplitude. It may be:
\itemize{
\item \code{"intensity"}. The amplitude of the peak is proportional to the raw intensity at the apex. This is a bad estimation if
the intensity includes a baseline, because the amplitude of the peak will be overestimated
\item \code{"2nd_derivative"}: The amplitude of the peak is proportional to the second derivative of the raw intensity signal at the apex.
This method aims to correct the "intensity" method, since it is expected that the baseline will be mostly removed
when considering the 2nd derivative of the spectrum. The 2nd derivative is calculated with a 2nd order Savitzky-Golay filter of 21 points.
\item \code{"intensity_without_baseline"}: A baseline is estimated on the whole spectra and subtracted from it. Then the peak amplitude
is proportional to the corrected intensity at the apex (as in the "intensity" method).
}}

\item{refine_peak_model}{Whether a non linear least squares fitting should be used to refine the estimated parameters. It can be:
\itemize{
\item \code{"none"}: Do not refine using nls.
\item \code{"peak"}: Use a lorentzian peak model and the baseline corrected spectra.
\item \code{"2nd_derivative"}:
}}
}
\value{
The given data frame \code{peak_data}, with added columns:
\itemize{
\item inflection points,
\item gamma
\item area
\item a norm_rmse fitting error
}

As well as some attributes
\itemize{
\item "errors": A data frame with any error in the peak fitting
\item "fit_baseline": Whether the method used has any consideration for the baseline of the signal (maybe not very useful attribute)
\item "method_description": A textual description of what we did, to include it in plots
}
}
\description{
The different methods are available for benchmarking while developing, we should pick one.
}
\details{
\itemize{
\item gamma is estimated using the inflection points of the signal and fitting them to the lorentzian inflection points
\item $A$ is estimated using the \code{amplitude_method} below
\item The peak position ($x_0$) is given in \code{peak_data}
}

Those estimations may be refined with non-linear least squares using \code{refine_peak_model}. If the nls does not converge,
the initial estimations are kept. Convergence -and other nls errors- are saved for further reference and diagnostic.
Use \code{attr(peak_data_fitted, "errors")} to retreive the error messages, where \code{peak_data_fitted} is assumed to be the
output of this function. The refining improves gamma, $A$ and $x_0$.

The baseline estimation (when calculated, see the arguments) is set to Asymmetric Least Squares with
lambda = 6, p=0.05, maxit=20 and it is probably not optimal... yet.
}
