% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_detect_peaks_align.R
\name{nmr_ppm_resolution}
\alias{nmr_ppm_resolution}
\alias{nmr_ppm_resolution.nmr_dataset}
\alias{nmr_ppm_resolution.nmr_dataset_1D}
\title{PPM resolution of the spectra}
\usage{
nmr_ppm_resolution(nmr_dataset)

\method{nmr_ppm_resolution}{nmr_dataset}(nmr_dataset)

\method{nmr_ppm_resolution}{nmr_dataset_1D}(nmr_dataset)
}
\arguments{
\item{nmr_dataset}{An object containing NMR samples}
}
\value{
Numeric (the ppm resolution, measured in ppms)
}
\description{
The function gets the ppm resolution of the dataset using the median of the
difference of data points.
}
\examples{
nmr_dataset <- nmr_dataset_load(system.file("extdata", "nmr_dataset.rds", package = "AlpsNMR"))
nmr_ppm_resolution(nmr_dataset)
message("the ppm resolution of this dataset is ", nmr_ppm_resolution(nmr_dataset), " ppm")

nmr_dataset <- nmr_dataset_load(system.file("extdata", "nmr_dataset.rds", package = "AlpsNMR"))
nmr_ppm_resolution(nmr_dataset)
message("the ppm resolution of this dataset is ", nmr_ppm_resolution(nmr_dataset), " ppm")

nmr_dataset <- nmr_dataset_load(system.file("extdata", "nmr_dataset.rds", package = "AlpsNMR"))
nmr_ppm_resolution(nmr_dataset)
message("the ppm resolution of this dataset is ", nmr_ppm_resolution(nmr_dataset), " ppm")
}
\seealso{
Other nmr_dataset_1D functions: 
\code{\link{[.nmr_dataset_1D}()},
\code{\link{format.nmr_dataset_1D}()},
\code{\link{get_integration_with_metadata}()},
\code{\link{is.nmr_dataset_1D}()},
\code{\link{nmr_integrate_peak_positions}()},
\code{\link{nmr_integrate_regions}()},
\code{\link{nmr_meta_add}()},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_meta_get}()},
\code{\link{nmr_meta_get_column}()},
\code{\link{print.nmr_dataset_1D}()}
}
\concept{nmr_dataset_1D functions}
