% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_identify_regions.R
\name{nmr_identify_regions_cell}
\alias{nmr_identify_regions_cell}
\title{NMR peak identification (cell samples)}
\usage{
nmr_identify_regions_cell(
  ppm_to_assign,
  num_proposed_compounds = 3,
  verbose = FALSE
)
}
\arguments{
\item{ppm_to_assign}{A vector with the ppm regions to assign}

\item{num_proposed_compounds}{set the number of proposed metabolites in \code{HMDB_cell}.}

\item{verbose}{Logical value. Set it to TRUE to print additional information}
}
\value{
a data frame with plausible assignations.
}
\description{
Identify given regions and return a data frame with plausible assignations
in cell samples.
}
\examples{
# We identify regions from from the corresponding ppm storaged in a vector.
ppm_to_assign <- c(
    4.060960203, 3.048970634, 2.405935596,
    3.24146865, 0.990616851, 1.002075066, 0.955325548
)
identification <- nmr_identify_regions_cell(ppm_to_assign, num_proposed_compounds = 3)
}
\seealso{
Other peak detection functions: 
\code{\link{Pipelines}},
\code{\link{nmr_baseline_threshold}()},
\code{\link{nmr_detect_peaks}()},
\code{\link{nmr_detect_peaks_plot}()},
\code{\link{nmr_detect_peaks_plot_overview}()},
\code{\link{nmr_detect_peaks_tune_snr}()},
\code{\link{nmr_identify_regions_blood}()},
\code{\link{nmr_identify_regions_urine}()},
\code{\link{nmr_integrate_regions}()}

Other peak integration functions: 
\code{\link{Pipelines}},
\code{\link{get_integration_with_metadata}()},
\code{\link{nmr_identify_regions_blood}()},
\code{\link{nmr_identify_regions_urine}()},
\code{\link{nmr_integrate_peak_positions}()},
\code{\link{nmr_integrate_regions}()}
}
\concept{peak detection functions}
\concept{peak integration functions}
