% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_exclude_region.R
\name{nmr_exclude_region}
\alias{nmr_exclude_region}
\alias{nmr_exclude_region.nmr_dataset_1D}
\title{Exclude region from samples}
\usage{
nmr_exclude_region(samples, exclude = list(water = c(4.7, 5)))

\method{nmr_exclude_region}{nmr_dataset_1D}(samples, exclude = list(water = c(4.7, 5)))
}
\arguments{
\item{samples}{An object}

\item{exclude}{A list with regions to be removed Typically:
\code{exclude = list(water = c(4.7, 5.0))}}
}
\value{
The same object, with the regions excluded
}
\description{
Excludes a given region (for instance to remove the water peak)
}
\examples{
nmr_dataset <- nmr_dataset_load(system.file("extdata", "nmr_dataset.rds", package = "AlpsNMR"))
exclude_regions <- list(water = c(5.1, 4.5))
nmr_dataset <- nmr_exclude_region(nmr_dataset, exclude = exclude_regions)

nmr_dataset <- nmr_dataset_load(system.file("extdata", "nmr_dataset.rds", package = "AlpsNMR"))
exclude_regions <- list(water = c(5.1, 4.5))
nmr_dataset <- nmr_exclude_region(nmr_dataset, exclude = exclude_regions)

}
\seealso{
Other basic functions: 
\code{\link{nmr_normalize}()}
}
\concept{basic functions}
