% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxillary-methods.R
\docType{methods}
\name{phase2genotype}
\alias{phase2genotype}
\alias{phase2genotype,array-method}
\title{phase2genotype}
\usage{
phase2genotype(x, ...)

\S4method{phase2genotype}{array}(x, ref, alt, return.class = "matrix", ...)
}
\arguments{
\item{x}{array see examples}

\item{...}{pass on additional param}

\item{ref}{reference allele vector}

\item{alt}{alternative allele vector}

\item{return.class}{'matrix' or 'array'}
}
\description{
Convert the phase from the internally stored phase, ref and alt information
}
\details{
To not introduce redundant information in the ASEset object, the genotype matrix is
accessed from the phase matrix, which together with ref and alt allele information
contains the same information(not taken into account three-allelic or more SNPs).

The genotype matrix retrieved from an ASEset object can differ from the genotype matrix
stored in the object if reference and alternative alleles were not used or has changed
since the phase genotype matrix was stored. Basically, it is preferable to provide
reference and alternative information when storing the genotype matrix.

If possible, it is better to not use a genotype matrix, but instead relying completely
on storing a phase matrix(or array) together with reference and alternative allele
information.
}
\examples{

#load example data
data(ASEset)
data(genomatrix)
p <- genotype2phase(genomatrix, ref(ASEset), return.class="array")
ref <- ref(ASEset)
alt <- inferAltAllele(ASEset)

gt <- phase2genotype(p, ref, alt, return.class="matrix")

}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{phase}
