% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize-methods.R
\name{initialize-DetectedAI}
\alias{initialize-DetectedAI}
\alias{DetectedAIFromArray}
\title{Initialize DetectedAI}
\usage{
DetectedAIFromArray(
  x = "ASEset",
  strand = "*",
  reference.frequency = NULL,
  threshold.frequency = NULL,
  threshold.count.sample = NULL,
  threshold.delta.frequency = NULL,
  threshold.pvalue = NULL,
  threshold.frequency.names = NULL,
  threshold.count.sample.names = NULL,
  threshold.delta.frequency.names = NULL,
  threshold.pvalue.names = NULL,
  ...
)
}
\arguments{
\item{x}{\code{ASEset}}

\item{strand}{set strand to detectAI over "+","-","*"}

\item{reference.frequency}{frequencies of reference alleles based allele counts}

\item{threshold.frequency}{logical array for frequency thresholds}

\item{threshold.count.sample}{logical array for per sample allele count thresholds}

\item{threshold.delta.frequency}{logical array for delta frequency thresholds.}

\item{threshold.pvalue}{logical array for pvalue thresholds (max 1, min 0)}

\item{threshold.frequency.names}{character vector}

\item{threshold.count.sample.names}{character vector}

\item{threshold.delta.frequency.names}{character vector}

\item{threshold.pvalue.names}{character vector}

\item{...}{internal arguments}
}
\description{
Functions to construct DetectedAI objects
}
\details{
produces a class container for reference bias calculations
}
\examples{

data(ASEset)
a <- ASEset
dai <- detectAI(a)

}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{bias}
\keyword{mapbias}
\keyword{refBias}
