% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxillary-methods.R
\docType{methods}
\name{getSnpIdFromLocation}
\alias{getSnpIdFromLocation}
\alias{getSnpIdFromLocation,GRanges-method}
\title{Get rsIDs from locations of SNP}
\usage{
getSnpIdFromLocation(GR, ...)

\S4method{getSnpIdFromLocation}{GRanges}(GR, SNPloc, return.vector = FALSE, verbose = TRUE)
}
\arguments{
\item{GR}{A \code{GRanges} that contains positions of SNPs to look up}

\item{...}{arguments to pass on}

\item{SNPloc}{A \code{SNPlocs object} containing information on SNP
locations (e.g. SNPlocs.Hsapiens.dbSNP.xxxxxxxx)}

\item{return.vector}{Setting \code{return.vector=TRUE} returns vector with
rsIds}

\item{verbose}{Setting \code{verbose=TRUE} makes function more talkative}
}
\value{
\code{getSnpIdFromLocation} returns the same GRanges object it was
given with, but with updated with rs.id information.
}
\description{
Given a GRanges object of SNPs and a SNPlocs annotation, this function
attempts to replace the names of the GRanges object entries with rs-IDs.
}
\details{
This function is used to try to identify the rs-IDs of SNPs in a GRanges
object.
}
\examples{

is_32bit_windows <- .Platform$OS.type == "windows" &&
                  .Platform$r_arch == "i386"
if (!is_32bit_windows && require(SNPlocs.Hsapiens.dbSNP144.GRCh37)) {
	#load example data
	data(ASEset)

  #get counts at the three positions specified in GRvariants
  updatedGRanges <- getSnpIdFromLocation(rowRanges(ASEset),
    SNPlocs.Hsapiens.dbSNP144.GRCh37)
}


}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{SNP}
\keyword{rs-id}
