% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxillary-methods.R
\docType{methods}
\name{genotype2phase}
\alias{genotype2phase}
\alias{genotype2phase,matrix-method}
\title{genotype2phase}
\usage{
genotype2phase(x, ...)

\S4method{genotype2phase}{matrix}(
  x,
  ref = NULL,
  return.class = "array",
  levels = c("A", "C", "G", "T"),
  ...
)
}
\arguments{
\item{x}{matrix see examples}

\item{...}{pass on additional param}

\item{ref}{reference alleles}

\item{return.class}{'array' or 'list'}

\item{levels}{vector of expected alleles}
}
\description{
used to convert the genomatrix from the visually friendly matrix to phase array.
}
\details{
To not introduce redundant information in the ASEset object, the genotype matrix is
translated to a phase matrix, containing the same information.
Does not allow tri-allelic or multi-allelic SNPs, and if present the multi-allelic
SNPs will lose the least occuring genotype.

This function can handle indels, but if the reference allele is not provided, the
rank matrix which is temporary created might use lots of memory, depending on the
amount of indels among the genotypes. As conclusion, it is preferable to send in
reference genome when converting to phase.

levels information is only important if the reference allele has to be guessed,
and so if reference information is provided, the levels argument can be ignored.
}
\examples{

#load example data
data(genomatrix)
data(ASEset)
p <- genotype2phase(genomatrix, ref(ASEset))

}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{phase}
