% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect-methods.R
\docType{methods}
\name{detectAI}
\alias{detectAI}
\alias{detectAI,ASEset-method}
\title{detectAI}
\usage{
detectAI(x, ...)

\S4method{detectAI}{ASEset}(
  x,
  return.class = "DetectedAI",
  strand = "*",
  threshold.frequency = 0,
  threshold.count.sample = 1,
  threshold.delta.frequency = 0,
  threshold.pvalue = 0.05,
  inferGenotype = FALSE,
  random.ref = FALSE,
  function.test = "binom.test",
  verbose = TRUE,
  gc = FALSE,
  biasMatrix = FALSE
)
}
\arguments{
\item{x}{ASEset}

\item{...}{internal arguments}

\item{return.class}{class to return (atm only class 'logical')}

\item{strand}{strand to infer from}

\item{threshold.frequency}{least fraction to classify (see details)}

\item{threshold.count.sample}{least amount of counts to try to infer allele}

\item{threshold.delta.frequency}{minimum of frequency difference 
from 0.5 (or mapbias adjusted value)}

\item{threshold.pvalue}{pvalue over this number will be filtered out}

\item{inferGenotype}{infer genotypes based on count data in ASEset object}

\item{random.ref}{set the reference as random if you dont know. Affects interpretation of results.}

\item{function.test}{At the moment the only available option is 'binomial.test'}

\item{verbose}{makes function more talkative}

\item{gc}{use garbage collection when possible to save space}

\item{biasMatrix}{use biasMatrix in ASEset, or use default expected frequency of 0.5 for all sites}
}
\description{
detection of AllelicImbalance
}
\details{
threshold.frequency is the least fraction needed to classify as bi tri or
quad allelic SNPs. If 'all' then all of bi tri and quad allelic SNPs will use the same
threshold. Everything under the treshold will be regarded as noise. 'all' will return 
a matrix with snps as rows and uni bi tri and quad will be columns. For this function
Anything that will return TRUE for tri-allelicwill also return TRUE for uni and bi-allelic
for the same SNP an Sample. 

return.type 'ref' return only AI when reference allele is more expressed. 'alt' return only
AI when alternative allele is more expressed or 'all' for both 'ref' and 'alt' alleles.
Reference allele is the one present in the reference genome on the forward strand.

threshold.delta.frequency and function.test will use the value in mapBias(x) as expected value. 

function.test will use the two most expressed alleles for testing. Make therefore sure there
are no tri-allelic SNPs or somatic mutations among the SNPs in the ASEset. 

inferGenotype(), set TRUE it should be used with as much samples as possible. If you split up the
samples and run detectAI() on each sample separately, please make sure you have inferred 
the genotypes in before hand, alternatively used the genotypes detected by another variantCaller
or chip-genotypes. Use ONLY biallelic genotypes.
}
\examples{

#load example data
data(ASEset)
a <- ASEset

dai <- detectAI(a)


}
\author{
Jesper R. Gadin
}
\keyword{detection}
