% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecations.R
\name{cigar-utilities}
\alias{cigar-utilities}
\alias{realCigarPosition}
\alias{realCigarPositions}
\alias{realCigarPositionsList}
\alias{realCigarPosition.old}
\alias{realCigarPositions.old}
\alias{realCigarPositionsList.old}
\title{realCigarPosition}
\usage{
realCigarPosition.old(RleCigar, BpPos)

realCigarPositions.old(RleCigar)

realCigarPositionsList.old(RleCigarList)
}
\arguments{
\item{RleCigar}{An \code{Rle} containing cigar information}

\item{BpPos}{the absolute position on the chromosome of interest}

\item{RleCigarList}{An \code{RleList} containing cigar information}
}
\value{
realCigarPosition returns the new position
realCigarPositions returns a vector with the corrected positions to
be subsetted from a read.  \code{realCigarPositionsList} returns a list
where each element i a vector with the corrected positions to be subsetted
from a read.
}
\description{
From a GAlignments calculate the real corresponding position for each read
based on its cigar.
}
\details{
The main intention for these functions are to be the internal functions for
\code{scanForHeterozygotes} and \code{getAlleleCount}.
}
\examples{

  RleCigarList <-  cigarToRleList('3M4I93M')
  BpPos <- 5

  newPos <- realCigarPosition.old(RleCigar=RleCigarList[[1]], BpPos)
  newPositions <- realCigarPositions.old(RleCigar=RleCigarList[[1]])
  newPositionsList <- realCigarPositionsList.old(RleCigarList=RleCigarList)
}
\author{
Jesper R. Gadin
}
\keyword{internal}
