% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxillary-methods-summaries.R
\name{DetectedAI-summary}
\alias{DetectedAI-summary}
\alias{frequency_vs_threshold_variable_summary}
\alias{frequency_vs_threshold_variable_summary,DetectedAI-method}
\alias{detectedAI_vs_threshold_variable_summary}
\alias{detectedAI_vs_threshold_variable_summary,DetectedAI-method}
\alias{usedSNPs_vs_threshold_variable_summary}
\alias{usedSNPs_vs_threshold_variable_summary,DetectedAI-method}
\title{DetectedAI summary}
\usage{
frequency_vs_threshold_variable_summary(x, ...)

\S4method{frequency_vs_threshold_variable_summary}{DetectedAI}(
  x,
  var = "threshold.count.sample",
  return.class = "matrix",
  ...
)

detectedAI_vs_threshold_variable_summary(x, ...)

\S4method{detectedAI_vs_threshold_variable_summary}{DetectedAI}(x, var = "threshold.count.sample")

usedSNPs_vs_threshold_variable_summary(x, ...)

\S4method{usedSNPs_vs_threshold_variable_summary}{DetectedAI}(x, var = "threshold.count.sample")
}
\arguments{
\item{x}{detectedAI object}

\item{...}{pass on variables internally}

\item{var}{string, see details for available options}

\item{return.class}{'matrix' or 'array'}
}
\description{
Summary helper functions for the DetectedAI-class
}
\details{
Summary helper functions. The documentation will
be improved before next release.
}
\examples{

#some example code here
#generate example
data(ASEset)
a <- ASEset
dai <- detectAI(a, 
			threshold.count.sample=1:50,
			threshold.frequency=seq(0,0.5,by=0.01),
			threshold.delta.frequency=seq(0,0.5,by=0.01),
			threshold.pvalue=rev(seq(0.001,0.05, by=0.005))
)

frequency_vs_threshold_variable_summary(dai)


}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{list}
